/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.AbstractRecord;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;

public final class DefaultRecord
extends AbstractRecord {
    private volatile Object valueObject;
    private volatile Data value;

    public DefaultRecord(CMap cmap, int blockId, Data key, Data value, long ttl, long maxIdleMillis, long id) {
        super(cmap, blockId, key, ttl, maxIdleMillis, id);
        this.value = value;
    }

    @Override
    public Record copy() {
        DistributedLock dl;
        DefaultRecord recordCopy = new DefaultRecord(this.cmap, this.blockId, this.key, this.value, this.getRemainingTTL(), this.getRemainingIdle(), this.id);
        if (this.optionalInfo != null) {
            recordCopy.setIndexes(this.getOptionalInfo().indexes, this.getOptionalInfo().indexTypes);
            recordCopy.setMultiValues(this.getOptionalInfo().lsMultiValues);
        }
        if ((dl = this.lock) != null) {
            recordCopy.setLock(new DistributedLock(dl));
        }
        recordCopy.setVersion(this.getVersion());
        return recordCopy;
    }

    @Override
    public Data getValueData() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        if (this.cmap.isCacheValue()) {
            Object currentValue = this.valueObject;
            if (currentValue != null) {
                return currentValue;
            }
            DefaultRecord defaultRecord = this;
            synchronized (defaultRecord) {
                Object v;
                if (this.valueObject != null) {
                    return this.valueObject;
                }
                this.valueObject = v = IOUtil.toObject(this.value);
                return v;
            }
        }
        return IOUtil.toObject(this.value);
    }

    @Override
    public Object setValue(Object value) {
        Object oldValue = this.getValue();
        this.valueObject = value;
        return oldValue;
    }

    @Override
    protected void invalidateValueCache() {
        if (this.cmap.isCacheValue()) {
            this.valueObject = null;
        }
    }

    @Override
    public void setValueData(Data value) {
        this.value = value;
        this.invalidateValueCache();
    }

    @Override
    public int valueCount() {
        int count = 0;
        if (this.hasValueData()) {
            count = 1;
        } else if (this.getMultiValues() != null) {
            count = this.getMultiValues().size();
        }
        return count;
    }

    @Override
    public long getCost() {
        long cost = 0L;
        Data dataValue = this.getValueData();
        Data dataKey = this.getKeyData();
        if (dataValue != null) {
            cost = dataValue.size();
            if (this.valueObject != null) {
                cost += (long)dataValue.size();
            }
        } else if (this.getMultiValues() != null && this.getMultiValues().size() > 0) {
            for (ValueHolder valueHolder : this.getMultiValues()) {
                if (valueHolder == null) continue;
                cost += (long)valueHolder.getData().size();
            }
        }
        return cost + (long)dataKey.size() + 312L;
    }

    @Override
    public boolean hasValueData() {
        return this.value != null;
    }

    @Override
    public void invalidate() {
        this.value = null;
        this.invalidateValueCache();
    }
}

