/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.CountingOutputstream;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.io.WriteableChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class WriteableChunkModifer
implements ChunkModifier {
    private final WriteableChunk writableChunk;

    public WriteableChunkModifer(WriteableChunk chunk) {
        this.writableChunk = chunk;
    }

    public boolean isApplicable(GUID guid) {
        return guid.equals(this.writableChunk.getGuid());
    }

    public ModificationResult modify(GUID guid, InputStream chunk, OutputStream destination) throws IOException {
        int chunkDiff = 0;
        long newSize = 0L;
        long oldSize = 0L;
        assert ((destination = new CountingOutputstream(destination)) != null);
        if (!this.writableChunk.isEmpty()) {
            newSize = this.writableChunk.writeInto(destination);
            assert (newSize == this.writableChunk.getCurrentAsfChunkSize());
            assert (((CountingOutputstream)destination).getCount() == newSize);
            if (guid == null) {
                ++chunkDiff;
            }
        }
        if (guid != null) {
            assert (this.isApplicable(guid));
            if (this.writableChunk.isEmpty()) {
                --chunkDiff;
            }
            oldSize = Utils.readUINT64(chunk);
            chunk.skip(oldSize - 24L);
        }
        return new ModificationResult(chunkDiff, newSize - oldSize, guid);
    }
}

