/*
 * Copyright (c) 2008-2012, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.impl;

import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.Instance;
import com.hazelcast.core.Member;
import com.hazelcast.impl.monitor.CountDownLatchOperationsCounter;
import com.hazelcast.nio.Address;

public interface CountDownLatchProxy extends ICountDownLatch, Instance, HazelcastInstanceAwareInstance {
    public final static int AWAIT_DONE = 0;
    public final static int AWAIT_FAILED = 1;
    public final static int INSTANCE_DESTROYED = 2;
    public final static int OWNER_LEFT = 3;

    public boolean setCount(int count, Address ownerAddress);

    public int getCount();

    public Member getOwner();

    CountDownLatchOperationsCounter getCountDownLatchOperationsCounter();

    String getLongName();
}
