/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Util;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.query.DateHelper;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateType;
import com.hazelcast.query.QueryContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Predicates {
    public static Predicate instanceOf(final Class klass) {
        return new Predicate(){

            public boolean apply(MapEntry mapEntry) {
                Object value = mapEntry.getValue();
                if (value == null) {
                    return false;
                }
                return klass.isAssignableFrom(value.getClass());
            }

            public String toString() {
                return " instanceOf (" + klass.getName() + ")";
            }
        };
    }

    public static Predicate and(Predicate x, Predicate y) {
        return new AndOrPredicate(true, x, y);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate or(Predicate x, Predicate y) {
        return new AndOrPredicate(false, x, y);
    }

    public static Predicate notEqual(Expression x, Object y) {
        return new NotEqualPredicate(x, y);
    }

    public static Predicate equal(Expression x, Object y) {
        return new EqualPredicate(x, y);
    }

    public static Predicate like(Expression<String> x, String pattern) {
        return new LikePredicate(x, pattern);
    }

    public static <T extends Comparable<T>> Predicate greaterThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, false);
    }

    public static <T extends Comparable<T>> Predicate greaterEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, false);
    }

    public static <T extends Comparable<T>> Predicate lessThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, true);
    }

    public static <T extends Comparable<T>> Predicate lessEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, true);
    }

    public static <T extends Comparable<T>> Predicate between(Expression<? extends T> expression, T from, T to) {
        return new BetweenPredicate(expression, from, to);
    }

    public static <T extends Comparable<T>> Predicate in(Expression<? extends T> expression, T ... values) {
        return new InPredicate(expression, values);
    }

    public static Predicate isNot(final Expression<Boolean> x) {
        return new Predicate(){

            public boolean apply(MapEntry entry) {
                Boolean value = (Boolean)x.getValue(entry);
                return Boolean.FALSE.equals(value);
            }
        };
    }

    public static GetExpression get(String methodName) {
        return new GetExpressionImpl(methodName);
    }

    public static abstract class AbstractExpression
    extends SerializationHelper
    implements Expression {
    }

    public static abstract class AbstractPredicate
    extends SerializationHelper
    implements Predicate,
    DataSerializable {
        public static Object getRealObject(Object type, Object value) {
            String valueString = String.valueOf(value);
            Object result = null;
            if (type instanceof Boolean) {
                result = "true".equalsIgnoreCase(valueString);
            } else if (type instanceof Integer) {
                result = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(valueString);
            } else if (type instanceof Long) {
                result = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(valueString);
            } else if (type instanceof Double) {
                result = value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(valueString);
            } else if (type instanceof Float) {
                result = value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(valueString);
            } else if (type instanceof Byte) {
                result = value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : Byte.valueOf(valueString);
            } else if (type instanceof Timestamp) {
                result = value instanceof java.util.Date ? value : DateHelper.parseTimeStamp(valueString);
            } else if (type instanceof Date) {
                result = value instanceof java.util.Date ? value : DateHelper.parseSqlDate(valueString);
            } else if (type instanceof java.util.Date) {
                result = value instanceof java.util.Date ? value : DateHelper.parseDate(valueString);
            } else if (type.getClass().isEnum()) {
                try {
                    String lastEnum = valueString;
                    if (valueString.contains(".")) {
                        lastEnum = valueString.substring(1 + valueString.lastIndexOf("."));
                    }
                    Enum enumType = (Enum)type;
                    result = Enum.valueOf(enumType.getClass(), lastEnum);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Illegal enum value specification: " + iae.getMessage());
                }
            } else {
                throw new RuntimeException("Unknown type " + type + " value=" + valueString);
            }
            return result;
        }
    }

    public static class AndOrPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Predicate[] predicates;
        boolean and = false;

        public AndOrPredicate() {
        }

        public AndOrPredicate(boolean and, Predicate first, Predicate second) {
            this.and = and;
            this.predicates = new Predicate[]{first, second};
        }

        public AndOrPredicate(boolean and, Predicate ... predicates) {
            this.and = and;
            this.predicates = predicates;
        }

        public boolean apply(MapEntry mapEntry) {
            Predicate[] predicateArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = predicateArray[n2];
                boolean result = predicate.apply(mapEntry);
                if (this.and && !result) {
                    return false;
                }
                if (!this.and && result) {
                    return true;
                }
                ++n2;
            }
            return this.and;
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            boolean strong = this.and;
            if (!mapIndexes.isEmpty()) {
                lsIndexPredicates.add(this);
                if (strong) {
                    ArrayList<IndexAwarePredicate> indexPredicates = new ArrayList<IndexAwarePredicate>(this.predicates.length);
                    Predicate[] predicateArray = this.predicates;
                    int n = this.predicates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Predicate predicate = predicateArray[n2];
                        if (predicate instanceof IndexAwarePredicate) {
                            IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                            if (!p.collectIndexAwarePredicates(indexPredicates, mapIndexes)) {
                                strong = false;
                            }
                        } else {
                            strong = false;
                        }
                        if (!strong) break;
                        ++n2;
                    }
                }
                return strong;
            }
            if (this.and) {
                Predicate[] predicateArray = this.predicates;
                int n = this.predicates.length;
                int n3 = 0;
                while (n3 < n) {
                    Predicate predicate = predicateArray[n3];
                    if (predicate instanceof IndexAwarePredicate) {
                        IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                        if (!p.collectIndexAwarePredicates(lsIndexPredicates, mapIndexes)) {
                            strong = false;
                        }
                    } else {
                        strong = false;
                    }
                    ++n3;
                }
            }
            return strong;
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return true;
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            results = null;
            var6_3 = this.predicates;
            var5_4 = this.predicates.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                block13: {
                    predicate = var6_3[var4_5];
                    filter = null;
                    if (!(predicate instanceof IndexAwarePredicate) || !((IndexAwarePredicate)predicate).isIndexed(queryContext)) break block13;
                    p = (IndexAwarePredicate)predicate;
                    filter = p.filter(queryContext);
                    ** GOTO lbl27
                }
                filter = new HashSet<E>();
                if (this.and && results != null) {
                    for (MapEntry result : results) {
                        if (!predicate.apply(result)) continue;
                        filter.add(result);
                    }
                    results = filter;
                } else {
                    for (MapEntry entry : queryContext.getMapIndexService().getOwnedRecords()) {
                        if (!predicate.apply(entry)) continue;
                        filter.add(entry);
                    }
lbl27:
                    // 2 sources

                    if (this.and && (filter == null || filter.isEmpty())) {
                        return null;
                    }
                    if (results == null) {
                        results = this.and ? filter : (filter == null ? new HashSet<E>() : new HashSet<Object>(filter));
                    } else if (this.and) {
                        direct = results.size() < filter.size();
                        s1 = direct != false ? results : filter;
                        s2 = direct != false ? filter : results;
                        results = new HashSet<E>();
                        for (MapEntry next : s1) {
                            if (!s2.contains(next)) continue;
                            results.add(next);
                        }
                        if (results.isEmpty()) {
                            return null;
                        }
                    } else if (filter != null) {
                        results.addAll(filter);
                    }
                }
                ++var4_5;
            }
            return results;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            if (this.and) {
                Predicate[] predicateArray = this.predicates;
                int n = this.predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (predicate instanceof IndexAwarePredicate) {
                        IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                        p.collectAppliedIndexes(setAppliedIndexes, mapIndexes);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeBoolean(this.and);
            out.writeInt(this.predicates.length);
            Predicate[] predicateArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate predicate = predicateArray[n2];
                AndOrPredicate.writeObject(out, predicate);
                ++n2;
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.and = in.readBoolean();
            int len = in.readInt();
            this.predicates = new Predicate[len];
            int i = 0;
            while (i < len) {
                this.predicates[i] = (Predicate)AndOrPredicate.readObject(in);
                ++i;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            String andOr = this.and ? " AND " : " OR ";
            int size = this.predicates.length;
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    sb.append(andOr);
                }
                sb.append(this.predicates[i]);
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class BetweenPredicate
    extends EqualPredicate {
        Object to;
        Comparable fromConvertedValue = null;
        Comparable toConvertedValue = null;

        public BetweenPredicate() {
        }

        public BetweenPredicate(Expression first, Expression from, Object to) {
            super(first, from);
            this.to = to;
        }

        public BetweenPredicate(Expression first, Object from, Object to) {
            super(first, from);
            this.to = to;
        }

        @Override
        public boolean apply(MapEntry entry) {
            Expression cFirst = this.first;
            Comparable firstValue = (Comparable)cFirst.getValue(entry);
            if (firstValue == null) {
                return false;
            }
            if (this.fromConvertedValue == null) {
                this.fromConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.second);
                this.toConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.to);
            }
            if (firstValue == null || this.fromConvertedValue == null || this.toConvertedValue == null) {
                return false;
            }
            return firstValue.compareTo(this.fromConvertedValue) >= 0 && firstValue.compareTo(this.toConvertedValue) <= 0;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            return index.getSubRecordsBetween(index.getLongValue(this.second), index.getLongValue(this.to));
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            BetweenPredicate.writeObject(out, this.to);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.to = BetweenPredicate.readObject(in);
        }

        @Override
        public String toString() {
            return this.first + " BETWEEN " + this.second + " AND " + this.to;
        }
    }

    public static class EqualPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object second;
        Object convertedSecondValue = null;
        protected boolean secondIsExpression = false;

        public EqualPredicate() {
        }

        public EqualPredicate(Expression first, Expression second) {
            this.first = first;
            this.second = second;
            this.secondIsExpression = true;
        }

        public EqualPredicate(Expression first, Object second) {
            this.first = first;
            this.second = second;
        }

        public boolean apply(MapEntry entry) {
            if (this.secondIsExpression) {
                return this.doApply(this.first.getValue(entry), ((Expression)this.second).getValue(entry));
            }
            Object firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.convertedSecondValue == null) {
                this.convertedSecondValue = EqualPredicate.getConvertedRealValue(firstVal, this.second);
            }
            return this.doApply(firstVal, this.convertedSecondValue);
        }

        protected static Object getConvertedRealValue(Object firstValue, Object value) {
            if (firstValue == null) {
                return value;
            }
            if (firstValue.getClass() == value.getClass()) {
                return value;
            }
            return EqualPredicate.getRealObject(firstValue, value);
        }

        protected boolean doApply(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            Index index;
            if (!this.secondIsExpression && this.first instanceof GetExpression && (index = mapIndexes.get(this.first)) != null) {
                lsIndexPredicates.add(this);
                return true;
            }
            return false;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return queryContext.getMapIndexes().get(this.first) != null;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                return index.getRecords(index.getLongValue(this.second));
            }
            return null;
        }

        public Object getValue() {
            return this.second;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            EqualPredicate.writeObject(out, this.first);
            out.writeBoolean(this.secondIsExpression);
            EqualPredicate.writeObject(out, this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)EqualPredicate.readObject(in);
                this.secondIsExpression = in.readBoolean();
                this.second = EqualPredicate.readObject(in);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + "=" + this.second;
        }
    }

    static interface GetExpression<T>
    extends Expression {
        public GetExpression get(String var1);
    }

    public static final class GetExpressionImpl<T>
    extends AbstractExpression
    implements GetExpression,
    DataSerializable {
        transient Getter getter = null;
        String input;
        List<GetExpressionImpl<T>> ls = null;

        public GetExpressionImpl() {
        }

        public GetExpressionImpl(String input) {
            this.input = input;
        }

        @Override
        public GetExpression get(String methodName) {
            if (this.ls == null) {
                this.ls = new ArrayList<GetExpressionImpl<T>>();
            }
            this.ls.add(new GetExpressionImpl<T>(methodName));
            return this;
        }

        public Object getValue(Object obj) {
            if (this.ls != null) {
                Object result = this.doGetValue(obj);
                for (GetExpressionImpl<T> e : this.ls) {
                    result = super.doGetValue(result);
                }
                return result;
            }
            return this.doGetValue(obj);
        }

        private Object doGetValue(Object obj) {
            if (obj instanceof MapEntry) {
                obj = ((MapEntry)obj).getValue();
            }
            if (obj == null) {
                return null;
            }
            try {
                if (this.getter == null) {
                    ThisGetter parent = null;
                    Class<?> clazz = obj.getClass();
                    ArrayList<String> possibleMethodNames = new ArrayList<String>(3);
                    String[] stringArray = this.input.split("\\.");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        Getter localGetter = null;
                        possibleMethodNames.clear();
                        possibleMethodNames.add(name);
                        String camelName = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
                        possibleMethodNames.add("get" + camelName);
                        possibleMethodNames.add("is" + camelName);
                        if (name.equals("this")) {
                            localGetter = new ThisGetter(parent, obj);
                        } else {
                            for (String methodName : possibleMethodNames) {
                                try {
                                    Method method = clazz.getMethod(methodName, null);
                                    method.setAccessible(true);
                                    localGetter = new MethodGetter(parent, method);
                                    clazz = method.getReturnType();
                                    break;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                            }
                            if (localGetter == null) {
                                try {
                                    Field field = clazz.getField(name);
                                    localGetter = new FieldGetter(parent, field);
                                    clazz = field.getType();
                                }
                                catch (NoSuchFieldException field) {
                                    // empty catch block
                                }
                            }
                            if (localGetter == null) {
                                Class<?> c = clazz;
                                while (!Object.class.equals(c)) {
                                    try {
                                        Field field = c.getDeclaredField(name);
                                        field.setAccessible(true);
                                        localGetter = new FieldGetter(parent, field);
                                        clazz = field.getType();
                                        break;
                                    }
                                    catch (NoSuchFieldException ignored) {
                                        c = c.getSuperclass();
                                    }
                                }
                            }
                        }
                        if (localGetter == null) {
                            throw new RuntimeException("There is no suitable accessor for '" + name + "'");
                        }
                        parent = localGetter;
                        ++n2;
                    }
                    this.getter = parent;
                }
                return this.getter.getValue(obj);
            }
            catch (Throwable e) {
                Util.throwUncheckedException(e);
                return null;
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.input);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.input = in.readUTF();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GetExpressionImpl)) {
                return false;
            }
            GetExpressionImpl that = (GetExpressionImpl)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return this.input.hashCode();
        }

        public String toString() {
            return this.input;
        }

        class FieldGetter
        extends Getter {
            final Field field;

            FieldGetter(Getter parent, Field field) {
                super(parent);
                this.field = field;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                obj = this.parent != null ? this.parent.getValue(obj) : obj;
                return obj != null ? this.field.get(obj) : null;
            }

            @Override
            Class getReturnType() {
                return this.field.getType();
            }

            public String toString() {
                return "FieldGetter [parent=" + this.parent + ", field=" + this.field + "]";
            }
        }

        abstract class Getter {
            protected final Getter parent;

            public Getter(Getter parent) {
                this.parent = parent;
            }

            abstract Object getValue(Object var1) throws Exception;

            abstract Class getReturnType();
        }

        class MethodGetter
        extends Getter {
            final Method method;

            MethodGetter(Getter parent, Method method) {
                super(parent);
                this.method = method;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                obj = this.parent != null ? this.parent.getValue(obj) : obj;
                return obj != null ? this.method.invoke(obj, new Object[0]) : null;
            }

            @Override
            Class getReturnType() {
                return this.method.getReturnType();
            }

            public String toString() {
                return "MethodGetter [parent=" + this.parent + ", method=" + this.method.getName() + "]";
            }
        }

        class ThisGetter
        extends Getter {
            final Object object;

            public ThisGetter(Getter parent, Object object) {
                super(parent);
                this.object = object;
            }

            @Override
            Object getValue(Object obj) throws Exception {
                return obj;
            }

            @Override
            Class getReturnType() {
                return this.object.getClass();
            }
        }
    }

    public static class GreaterLessPredicate
    extends EqualPredicate {
        boolean equal = false;
        boolean less = false;

        public GreaterLessPredicate() {
        }

        public GreaterLessPredicate(Expression first, Expression second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        public GreaterLessPredicate(Expression first, Object second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        @Override
        protected boolean doApply(Object first, Object second) {
            int result = ((Comparable)first).compareTo(second);
            return this.equal && result == 0 || !(this.less ? result >= 0 : result <= 0);
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            PredicateType predicateType = this.less ? (this.equal ? PredicateType.LESSER_EQUAL : PredicateType.LESSER) : (this.equal ? PredicateType.GREATER_EQUAL : PredicateType.GREATER);
            return index.getSubRecords(predicateType, index.getLongValue(this.second));
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.equal = in.readBoolean();
            this.less = in.readBoolean();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.equal);
            out.writeBoolean(this.less);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(this.less ? "<" : ">");
            if (this.equal) {
                sb.append("=");
            }
            sb.append(this.second);
            return sb.toString();
        }
    }

    public static class InPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object[] inValueArray = null;
        Set inValues = null;
        Set convertedInValues = null;
        Object firstValueObject = null;

        public InPredicate() {
        }

        public InPredicate(Expression first, Object ... second) {
            this.first = first;
            this.inValueArray = second;
        }

        private void checkInValues() {
            if (this.inValues == null) {
                this.inValues = new HashSet(this.inValueArray.length);
                Object[] objectArray = this.inValueArray;
                int n = this.inValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    this.inValues.add(o);
                    ++n2;
                }
            }
        }

        public boolean apply(MapEntry entry) {
            Object entryValue;
            this.checkInValues();
            if (this.firstValueObject == null) {
                this.firstValueObject = this.inValues.iterator().next();
            }
            if ((entryValue = this.first.getValue(entry)) == null) {
                return false;
            }
            if (this.convertedInValues != null) {
                return InPredicate.in(entryValue, this.convertedInValues);
            }
            if (entryValue.getClass() == this.firstValueObject.getClass()) {
                return InPredicate.in(entryValue, this.inValues);
            }
            if (this.firstValueObject instanceof String) {
                this.convertedInValues = new HashSet(this.inValues.size());
                for (Object objValue : this.inValues) {
                    this.convertedInValues.add(InPredicate.getRealObject(entryValue, objValue));
                }
                return InPredicate.in(entryValue, this.convertedInValues);
            }
            return InPredicate.in(entryValue, this.inValues);
        }

        private static boolean in(Object firstVal, Set values) {
            return values.contains(firstVal);
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            Index index;
            if (this.first instanceof GetExpression && (index = mapIndexes.get(this.first)) != null) {
                lsIndexPredicates.add(this);
                return true;
            }
            return false;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return queryContext.getMapIndexes().get(this.first) != null;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            this.checkInValues();
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                HashSet<Long> setLongValues = new HashSet<Long>(this.inValues.size());
                for (Object valueObj : this.inValues) {
                    Long value = index.getLongValue(valueObj);
                    setLongValues.add(value);
                }
                return index.getRecords(setLongValues);
            }
            return null;
        }

        public Object getValue() {
            return this.inValues;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            InPredicate.writeObject(out, this.first);
            out.writeInt(this.inValueArray.length);
            Object[] objectArray = this.inValueArray;
            int n = this.inValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                InPredicate.writeObject(out, value);
                ++n2;
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)InPredicate.readObject(in);
                int len = in.readInt();
                this.inValueArray = new Object[len];
                int i = 0;
                while (i < len) {
                    this.inValueArray[i] = InPredicate.readObject(in);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(" IN (");
            int i = 0;
            while (i < this.inValueArray.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.inValueArray[i]);
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class LikePredicate
    extends AbstractPredicate {
        Expression<String> first;
        String second;
        Pattern pattern = null;

        public LikePredicate() {
        }

        public LikePredicate(Expression<String> first, String second) {
            this.first = first;
            this.second = second;
        }

        public boolean apply(MapEntry entry) {
            String firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.second.replaceAll("%", ".*").replaceAll("_", "."));
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            LikePredicate.writeObject(out, this.first);
            out.writeUTF(this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)LikePredicate.readObject(in);
                this.second = in.readUTF();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + " LIKE '" + this.second + "'";
        }
    }

    public static class NotEqualPredicate
    extends EqualPredicate
    implements IndexAwarePredicate {
        public NotEqualPredicate() {
        }

        public NotEqualPredicate(Expression first, Expression second) {
            super(first, second);
        }

        public NotEqualPredicate(Expression first, Object second) {
            super(first, second);
        }

        @Override
        public boolean apply(MapEntry entry) {
            return !super.apply(entry);
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                return index.getSubRecords(PredicateType.NOT_EQUAL, index.getLongValue(this.second));
            }
            return null;
        }

        @Override
        public String toString() {
            return this.first + " != " + this.second;
        }
    }

    public static class NotPredicate
    extends AbstractPredicate {
        Predicate predicate;

        public NotPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public NotPredicate() {
        }

        public boolean apply(MapEntry mapEntry) {
            return !this.predicate.apply(mapEntry);
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            NotPredicate.writeObject(out, this.predicate);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.predicate = (Predicate)NotPredicate.readObject(in);
        }

        public String toString() {
            return "NOT(" + this.predicate + ")";
        }
    }

    public static class RegexPredicate
    extends AbstractPredicate {
        Expression<String> first;
        String regex;
        Pattern pattern = null;

        public RegexPredicate() {
        }

        public RegexPredicate(Expression<String> first, String regex) {
            this.first = first;
            this.regex = regex;
        }

        public boolean apply(MapEntry entry) {
            String firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.regex == null;
            }
            if (this.regex == null) {
                return false;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            RegexPredicate.writeObject(out, this.first);
            out.writeUTF(this.regex);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)RegexPredicate.readObject(in);
                this.regex = in.readUTF();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            return this.first + " REGEX '" + this.regex + "'";
        }
    }
}

