/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.monitor.MemberHealthStats;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ThreadStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberHealthStatsImpl
implements MemberHealthStats,
DataSerializable {
    boolean outOfMemory;
    boolean active;
    ThreadStats serviceThreadStats = new ThreadStats(0, 0L, 0L, true);
    ThreadStats inThreadStats = new ThreadStats(0, 0L, 0L, true);
    ThreadStats outThreadStats = new ThreadStats(0, 0L, 0L, true);

    @Override
    public void readData(DataInput in) throws IOException {
        this.outOfMemory = in.readBoolean();
        this.active = in.readBoolean();
        this.serviceThreadStats = this.readThreadStats(in);
        this.inThreadStats = this.readThreadStats(in);
        this.outThreadStats = this.readThreadStats(in);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeBoolean(this.outOfMemory);
        out.writeBoolean(this.active);
        this.writeThreadStats(out, this.serviceThreadStats);
        this.writeThreadStats(out, this.inThreadStats);
        this.writeThreadStats(out, this.outThreadStats);
    }

    void writeThreadStats(DataOutput out, ThreadStats t) throws IOException {
        out.writeInt(t.getUtilizationPercentage());
        out.writeLong(t.getRunCount());
        out.writeLong(t.getWaitCount());
        out.writeBoolean(t.isRunning());
    }

    ThreadStats readThreadStats(DataInput in) throws IOException {
        return new ThreadStats(in.readInt(), in.readLong(), in.readLong(), in.readBoolean());
    }

    @Override
    public ThreadStats getInThreadStats() {
        return this.inThreadStats;
    }

    public void setInThreadStats(ThreadStats inThreadStats) {
        this.inThreadStats = inThreadStats;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    public void setOutOfMemory(boolean outOfMemory) {
        this.outOfMemory = outOfMemory;
    }

    @Override
    public ThreadStats getOutThreadStats() {
        return this.outThreadStats;
    }

    public void setOutThreadStats(ThreadStats outThreadStats) {
        this.outThreadStats = outThreadStats;
    }

    @Override
    public ThreadStats getServiceThreadStats() {
        return this.serviceThreadStats;
    }

    public void setServiceThreadStats(ThreadStats serviceThreadStats) {
        this.serviceThreadStats = serviceThreadStats;
    }

    public String toString() {
        return "MemberHealthStatsImpl{outOfMemory=" + this.outOfMemory + ", active=" + this.active + ", serviceThreadStats=" + this.serviceThreadStats + ", inThreadStats=" + this.inThreadStats + ", outThreadStats=" + this.outThreadStats + '}';
    }
}

