/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ThreadDumpGenerator;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

class ThreadDumpGeneratorImpl_15
extends ThreadDumpGenerator {
    public ThreadDumpGeneratorImpl_15(ThreadMXBean bean) {
        super(bean);
    }

    @Override
    protected void appendThreadInfo(ThreadInfo info, StringBuilder sb) {
        sb.append("\"").append(info.getThreadName()).append("\"").append(" Id=").append(info.getThreadId()).append(" ").append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            ++i;
        }
        sb.append('\n');
    }
}

