/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.DataAwareItemEvent;
import com.hazelcast.impl.DataMessage;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class ListenerManager
extends BaseManager {
    final ConcurrentMap<String, List<ListenerItem>> namedListeners = new ConcurrentHashMap<String, List<ListenerItem>>(100);

    ListenerManager(Node node) {
        super(node);
        this.registerPacketProcessor(ClusterOperation.EVENT, new PacketProcessor(){

            @Override
            public void process(Packet packet) {
                ListenerManager.this.handleEvent(packet);
            }
        });
        this.registerPacketProcessor(ClusterOperation.ADD_LISTENER, new AddRemoveListenerOperationHandler());
        this.registerPacketProcessor(ClusterOperation.REMOVE_LISTENER, new AddRemoveListenerOperationHandler());
        this.registerPacketProcessor(ClusterOperation.ADD_LISTENER_NO_RESPONSE, new PacketProcessor(){

            @Override
            public void process(Packet packet) {
                ListenerManager.this.handleAddRemoveListener(true, packet);
            }
        });
    }

    private void handleEvent(Packet packet) {
        int eventType = (int)packet.longValue;
        Data key = packet.getKeyData();
        Data value = packet.getValueData();
        String name = packet.name;
        Address from = packet.lockAddress;
        this.releasePacket(packet);
        this.enqueueEvent(eventType, name, key, value, from, false);
    }

    private void handleAddRemoveListener(boolean add, Packet packet) {
        Data key = packet.getKeyData();
        boolean returnValue = packet.longValue == 1L;
        String name = packet.name;
        Address address = packet.conn.getEndPoint();
        this.releasePacket(packet);
        this.registerListener(add, name, key, address, returnValue);
    }

    public void syncForDead(Address deadAddress) {
        for (List listeners : this.namedListeners.values()) {
            for (ListenerItem listenerItem : listeners) {
                if (listenerItem.localListener) continue;
                this.registerListener(false, listenerItem.name, IOUtil.toData(listenerItem.key), deadAddress, listenerItem.includeValue);
            }
        }
    }

    public void syncForAdd() {
        for (List listeners : this.namedListeners.values()) {
            for (ListenerItem listenerItem : listeners) {
                if (listenerItem.localListener) continue;
                this.registerListenerWithNoResponse(listenerItem.name, listenerItem.key, listenerItem.includeValue);
            }
        }
    }

    public void syncForAdd(Address newAddress) {
        for (List listeners : this.namedListeners.values()) {
            for (ListenerItem listenerItem : listeners) {
                if (listenerItem.localListener) continue;
                Data dataKey = null;
                if (listenerItem.key != null) {
                    dataKey = ThreadContext.get().toData(listenerItem.key);
                }
                this.sendAddListener(newAddress, listenerItem.name, dataKey, listenerItem.includeValue);
            }
        }
    }

    private void registerListener(String name, Object key, boolean add, boolean includeValue) {
        if (key == null) {
            AddRemoveListener addRemoveListener = new AddRemoveListener(name, add, includeValue);
            addRemoveListener.call();
        } else {
            new ConcurrentMapManager.MAddKeyListener(this.node.concurrentMapManager).addListener(name, add, key, includeValue);
        }
    }

    private void registerListenerWithNoResponse(String name, Object key, boolean includeValue) {
        Data dataKey = null;
        if (key != null) {
            dataKey = ThreadContext.get().toData(key);
        }
        this.enqueueAndReturn(new ListenerRegistrationProcess(name, dataKey, includeValue));
    }

    void sendAddListener(Address toAddress, String name, Data key, boolean includeValue) {
        Packet packet = this.obtainPacket();
        packet.set(name, ClusterOperation.ADD_LISTENER_NO_RESPONSE, key, null);
        packet.longValue = includeValue ? 1 : 0;
        this.sendOrReleasePacket(packet, toAddress);
    }

    public synchronized void addLocalListener(final String name, Object listener, Instance.InstanceType instanceType) {
        List<ListenerItem> listeners = this.getOrCreateListenerList(name);
        ListenerItem listenerItem = new ListenerItem(name, null, listener, true, instanceType, true);
        listeners.add(listenerItem);
        this.node.concurrentMapManager.enqueueAndWait(new Processable(){

            @Override
            public void process() {
                ListenerManager.this.node.concurrentMapManager.getOrCreateMap(name).addListener(null, ListenerManager.this.node.getThisAddress(), true);
            }
        }, 10);
    }

    public synchronized List<ListenerItem> getOrCreateListenerList(String name) {
        CopyOnWriteArrayList listeners = (CopyOnWriteArrayList)this.namedListeners.get(name);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList();
            this.namedListeners.put(name, listeners);
        }
        return listeners;
    }

    public synchronized void addListener(String name, Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
        ListenerItem listenerItem2;
        List<ListenerItem> listeners = this.getOrCreateListenerList(name);
        boolean remotelyRegister = true;
        for (ListenerItem listenerItem2 : listeners) {
            if (!remotelyRegister) break;
            if (listenerItem2.localListener || !listenerItem2.name.equals(name)) continue;
            if (key == null) {
                if (listenerItem2.key != null || includeValue && listenerItem2.includeValue != includeValue) continue;
                remotelyRegister = false;
                continue;
            }
            if (listenerItem2.key == null || !listenerItem2.key.equals(key) || includeValue && listenerItem2.includeValue != includeValue) continue;
            remotelyRegister = false;
        }
        if (remotelyRegister) {
            this.registerListener(name, key, true, includeValue);
        }
        listenerItem2 = new ListenerItem(name, key, listener, includeValue, instanceType);
        listeners.add(listenerItem2);
    }

    public void removeListener(String name, Object listener, Object key) {
        List listeners = (List)this.namedListeners.get(name);
        if (listeners == null) {
            return;
        }
        for (ListenerItem listenerItem : listeners) {
            if (listener == null || !listener.equals(listenerItem.listener) || !listenerItem.name.equals(name)) continue;
            if (key == null && listenerItem.key == null) {
                listeners.remove(listenerItem);
                continue;
            }
            if (key == null || !key.equals(listenerItem.key)) continue;
            listeners.remove(listenerItem);
        }
        boolean left = false;
        for (ListenerItem listenerItem : listeners) {
            if (key == null && listenerItem.key == null) {
                left = true;
                continue;
            }
            if (key == null || !key.equals(listenerItem.key)) continue;
            left = true;
        }
        if (!left) {
            this.registerListener(name, key, false, false);
        }
    }

    void removeAllRegisteredListeners(String name) {
        this.namedListeners.remove(name);
    }

    void createAndAddListenerItem(String name, ListenerConfig lc, Instance.InstanceType instanceType) throws Exception {
        Object listener = lc.getImplementation();
        if (listener == null) {
            listener = Serializer.newInstance(Serializer.loadClass(lc.getClassName()));
        }
        if (listener != null) {
            ListenerItem listenerItem = new ListenerItem(name, null, listener, lc.isIncludeValue(), instanceType, lc.isLocal());
            this.getOrCreateListenerList(name).add(listenerItem);
        }
    }

    void callListeners(DataAwareEntryEvent dataAwareEntryEvent) {
        List<ListenerItem> listeners = this.getOrCreateListenerList(dataAwareEntryEvent.getLongName());
        for (ListenerItem listenerItem : listeners) {
            if (!listenerItem.listens(dataAwareEntryEvent)) continue;
            try {
                this.callListener(listenerItem, dataAwareEntryEvent);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Caught error while calling event listener; cause: " + e.getMessage(), e);
            }
        }
    }

    private void callListener(ListenerItem listenerItem, DataAwareEntryEvent event) {
        Object proxy;
        if (listenerItem.localListener && !event.firedLocally) {
            return;
        }
        Object listener = listenerItem.listener;
        EntryEventType entryEventType = event.getEventType();
        if (listenerItem.instanceType == Instance.InstanceType.MAP) {
            if (!listenerItem.name.startsWith("c:__hz_") && (proxy = this.node.factory.getOrCreateProxyByName(listenerItem.name)) instanceof MProxy) {
                MProxy mProxy = (MProxy)proxy;
                mProxy.getMapOperationCounter().incrementReceivedEvents();
            }
        } else if (listenerItem.instanceType == Instance.InstanceType.QUEUE) {
            if (!listenerItem.name.startsWith("q:__hz_") && (proxy = this.node.factory.getOrCreateProxyByName(listenerItem.name)) instanceof QProxy) {
                QProxy qProxy = (QProxy)proxy;
                qProxy.getQueueOperationCounter().incrementReceivedEvents();
            }
        } else if (listenerItem.instanceType == Instance.InstanceType.TOPIC && !listenerItem.name.startsWith("t:__hz_") && (proxy = this.node.factory.getOrCreateProxyByName(listenerItem.name)) instanceof TopicProxy) {
            TopicProxy tProxy = (TopicProxy)proxy;
            tProxy.getTopicOperationCounter().incrementReceivedMessages();
        }
        DataAwareEntryEvent event2 = listenerItem.includeValue ? event : (event.getNewValueData() != null ? new DataAwareEntryEvent(event.getMember(), event.getEventType().getType(), event.getLongName(), event.getKeyData(), null, null, event.firedLocally) : event);
        block0 : switch (listenerItem.instanceType) {
            case MAP: 
            case MULTIMAP: {
                EntryListener entryListener = (EntryListener)listener;
                switch (entryEventType) {
                    case ADDED: {
                        entryListener.entryAdded(event2);
                        break;
                    }
                    case REMOVED: {
                        entryListener.entryRemoved(event2);
                        break;
                    }
                    case UPDATED: {
                        entryListener.entryUpdated(event2);
                        break;
                    }
                    case EVICTED: {
                        entryListener.entryEvicted(event2);
                    }
                }
                break;
            }
            case SET: 
            case LIST: {
                ItemListener itemListener = (ItemListener)listener;
                switch (entryEventType) {
                    case ADDED: {
                        itemListener.itemAdded(new DataAwareItemEvent(listenerItem.name, ItemEventType.ADDED, event.getKeyData(), event.getMember()));
                        break;
                    }
                    case REMOVED: {
                        itemListener.itemRemoved(new DataAwareItemEvent(listenerItem.name, ItemEventType.REMOVED, event.getKeyData(), event.getMember()));
                    }
                }
                break;
            }
            case TOPIC: {
                MessageListener messageListener = (MessageListener)listener;
                messageListener.onMessage(new DataMessage(listenerItem.name, event.getNewValueData()));
                break;
            }
            case QUEUE: {
                ItemListener queueItemListener = (ItemListener)listener;
                switch (entryEventType) {
                    case ADDED: {
                        queueItemListener.itemAdded(new DataAwareItemEvent(listenerItem.name, ItemEventType.ADDED, event.getNewValueData(), event.getMember()));
                        break block0;
                    }
                    case REMOVED: {
                        queueItemListener.itemRemoved(new DataAwareItemEvent(listenerItem.name, ItemEventType.REMOVED, event.getNewValueData(), event.getMember()));
                    }
                }
            }
        }
    }

    public class AddRemoveListener
    extends BaseManager.MultiCall<Boolean> {
        final String name;
        final boolean add;
        final boolean includeValue;

        public AddRemoveListener(String name, boolean add, boolean includeValue) {
            this.name = name;
            this.add = add;
            this.includeValue = includeValue;
        }

        @Override
        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new AddListenerAtTarget(target);
        }

        @Override
        boolean onResponse(Object response) {
            return true;
        }

        @Override
        Object returnResult() {
            return Boolean.TRUE;
        }

        @Override
        protected boolean excludeLiteMember() {
            return false;
        }

        private final class AddListenerAtTarget
        extends BaseManager.SubCall {
            public AddListenerAtTarget(Address target) {
                super(target);
                ClusterOperation operation = AddRemoveListener.this.add ? ClusterOperation.ADD_LISTENER : ClusterOperation.REMOVE_LISTENER;
                this.setLocal(operation, AddRemoveListener.this.name, null, null, -1L, -1L);
                this.request.setBooleanRequest();
                this.request.longValue = AddRemoveListener.this.includeValue ? 1 : 0;
            }
        }
    }

    class AddRemoveListenerOperationHandler
    extends BaseManager.TargetAwareOperationHandler {
        AddRemoveListenerOperationHandler() {
        }

        @Override
        boolean isRightRemoteTarget(Request request) {
            return request.key == null || ListenerManager.this.thisAddress.equals(ListenerManager.this.node.concurrentMapManager.getKeyOwner(request));
        }

        @Override
        void doOperation(Request request) {
            Address from = request.caller;
            ListenerManager.this.logger.log(Level.FINEST, "AddListenerOperation from " + from + ", local=" + request.local + "  key:" + request.key + " op:" + (Object)((Object)request.operation));
            if (from == null) {
                throw new RuntimeException("Listener origin is not known!");
            }
            boolean add = request.operation == ClusterOperation.ADD_LISTENER;
            boolean includeValue = request.longValue == 1L;
            ListenerManager.this.registerListener(add, request.name, request.key, request.caller, includeValue);
            request.response = Boolean.TRUE;
        }
    }

    public static class ListenerItem
    extends AbstractRemotelyProcessable
    implements DataSerializable {
        public String name;
        public Object key;
        public Object listener;
        public boolean includeValue;
        public Instance.InstanceType instanceType;
        public boolean localListener = false;

        public ListenerItem() {
        }

        public ListenerItem(String name, Object key, Object listener, boolean includeValue, Instance.InstanceType instanceType) {
            this(name, key, listener, includeValue, instanceType, false);
        }

        public ListenerItem(String name, Object key, Object listener, boolean includeValue, Instance.InstanceType instanceType, boolean localListener) {
            this.key = key;
            this.listener = listener;
            this.name = name;
            this.includeValue = includeValue;
            this.instanceType = instanceType;
            this.localListener = localListener;
        }

        public boolean listens(DataAwareEntryEvent dataAwareEntryEvent) {
            String name = dataAwareEntryEvent.getLongName();
            return this.name.equals(name) && (this.key == null || dataAwareEntryEvent.getKey().equals(this.key));
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            ListenerItem.writeObject(out, this.key);
            out.writeBoolean(this.includeValue);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
            this.key = ListenerItem.readObject(in);
            this.includeValue = in.readBoolean();
        }

        @Override
        public void process() {
            this.getNode().listenerManager.registerListener(true, this.name, IOUtil.toData(this.key), this.getConnection().getEndPoint(), this.includeValue);
        }
    }

    final class ListenerRegistrationProcess
    implements Processable {
        final String name;
        final Data key;
        final boolean includeValue;

        public ListenerRegistrationProcess(String name, Data key, boolean includeValue) {
            this.key = key;
            this.name = name;
            this.includeValue = includeValue;
        }

        @Override
        public void process() {
            if (this.key != null) {
                this.processWithKey();
            } else {
                this.processWithoutKey();
            }
        }

        private void processWithKey() {
            Address owner = ListenerManager.this.node.concurrentMapManager.getKeyOwner(this.key);
            if (owner.equals(ListenerManager.this.thisAddress)) {
                ListenerManager.this.registerListener(true, this.name, this.key, ListenerManager.this.thisAddress, this.includeValue);
            } else {
                Packet packet = ListenerManager.this.obtainPacket();
                packet.set(this.name, ClusterOperation.ADD_LISTENER_NO_RESPONSE, this.key, null);
                packet.longValue = this.includeValue ? 1 : 0;
                ListenerManager.this.sendOrReleasePacket(packet, owner);
            }
        }

        private void processWithoutKey() {
            for (MemberImpl member : ListenerManager.this.lsMembers) {
                if (member.localMember()) {
                    ListenerManager.this.registerListener(true, this.name, null, ListenerManager.this.thisAddress, this.includeValue);
                    continue;
                }
                ListenerManager.this.sendAddListener(member.getAddress(), this.name, null, this.includeValue);
            }
        }
    }
}

