/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class NodeIOService
implements IOService {
    final Node node;

    public NodeIOService(Node node) {
        this.node = node;
    }

    @Override
    public boolean isActive() {
        return this.node.isActive();
    }

    @Override
    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    @Override
    public SystemLogService getSystemLogService() {
        return this.node.getSystemLogService();
    }

    @Override
    public void onOutOfMemory(OutOfMemoryError oom) {
        OutOfMemoryErrorDispatcher.onOutOfMemory(oom);
    }

    @Override
    public void handleInterruptedException(Thread thread, RuntimeException e) {
        this.node.handleInterruptedException(thread, e);
    }

    @Override
    public void onIOThreadStart() {
        ThreadContext.get().setCurrentFactory(this.node.factory);
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public void onFatalError(Exception e) {
        this.getSystemLogService().logConnection(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        this.node.shutdown(false, false);
    }

    @Override
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
    }

    @Override
    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getSymmetricEncryptionConfig();
    }

    @Override
    public AsymmetricEncryptionConfig getAsymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getAsymmetricEncryptionConfig();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.node.getConfig().getNetworkConfig().getSSLConfig();
    }

    @Override
    public void handleClientPacket(Packet p) {
        this.node.clientHandlerService.handle(p);
    }

    @Override
    public void handleMemberPacket(Packet p) {
        this.node.clusterService.enqueuePacket(p);
    }

    @Override
    public TextCommandService getTextCommandService() {
        return this.node.getTextCommandService();
    }

    @Override
    public boolean isMemcacheEnabled() {
        return this.node.groupProperties.MEMCACHE_ENABLED.getBoolean();
    }

    @Override
    public boolean isRestEnabled() {
        return this.node.groupProperties.REST_ENABLED.getBoolean();
    }

    @Override
    public void removeEndpoint(Address endPoint) {
        AddOrRemoveConnection addOrRemoveConnection = new AddOrRemoveConnection(endPoint, false);
        addOrRemoveConnection.setNode(this.node);
        this.node.clusterManager.enqueueAndReturn(addOrRemoveConnection);
    }

    @Override
    public String getThreadPrefix() {
        return this.node.getThreadPoolNamePrefix("IO");
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.node.threadGroup;
    }

    @Override
    public void onFailedConnection(Address address) {
        if (!this.node.joined()) {
            this.node.failedConnection(address);
        }
    }

    @Override
    public void shouldConnectTo(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            throw new RuntimeException("Connecting to self! " + address);
        }
    }

    @Override
    public boolean isReuseSocketAddress() {
        return this.node.getConfig().getNetworkConfig().isReuseAddress();
    }

    @Override
    public int getSocketPort() {
        return this.node.getConfig().getNetworkConfig().getPort();
    }

    @Override
    public boolean isSocketBindAny() {
        return this.node.groupProperties.SOCKET_CLIENT_BIND_ANY.getBoolean();
    }

    @Override
    public boolean isSocketPortAutoIncrement() {
        return this.node.getConfig().getNetworkConfig().isPortAutoIncrement();
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.node.getGroupProperties().SOCKET_RECEIVE_BUFFER_SIZE.getInteger();
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.node.getGroupProperties().SOCKET_SEND_BUFFER_SIZE.getInteger();
    }

    @Override
    public int getSocketLingerSeconds() {
        return this.node.getGroupProperties().SOCKET_LINGER_SECONDS.getInteger();
    }

    @Override
    public boolean getSocketKeepAlive() {
        return this.node.getGroupProperties().SOCKET_KEEP_ALIVE.getBoolean();
    }

    @Override
    public boolean getSocketNoDelay() {
        return this.node.getGroupProperties().SOCKET_NO_DELAY.getBoolean();
    }

    @Override
    public int getSelectorThreadCount() {
        return this.node.groupProperties.IO_THREAD_COUNT.getInteger();
    }

    @Override
    public void disconnectExistingCalls(final Address deadEndpoint) {
        if (deadEndpoint != null) {
            this.node.clusterManager.enqueueAndReturn(new Processable(){

                @Override
                public void process() {
                    NodeIOService.this.node.clusterManager.disconnectExistingCalls(deadEndpoint);
                }
            });
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public long getConnectionMonitorInterval() {
        return this.node.groupProperties.CONNECTION_MONITOR_INTERVAL.getLong();
    }

    @Override
    public int getConnectionMonitorMaxFaults() {
        return this.node.groupProperties.CONNECTION_MONITOR_MAX_FAULTS.getInteger();
    }

    @Override
    public void onShutdown() {
        try {
            ThreadContext.get().setCurrentFactory(this.node.factory);
            this.node.clusterManager.sendProcessableToAll(new AddOrRemoveConnection(this.getThisAddress(), false), false);
            Thread.sleep(100L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.node.executorManager.executeNow(runnable);
    }

    @Override
    public Collection<Integer> getOutboundPorts() {
        HashSet<Integer> ports;
        NetworkConfig networkConfig = this.node.getConfig().getNetworkConfig();
        Collection<Object> portDefinitions = networkConfig.getOutboundPortDefinitions() == null ? Collections.emptySet() : networkConfig.getOutboundPortDefinitions();
        HashSet<Integer> hashSet = ports = networkConfig.getOutboundPorts() == null ? new HashSet<Integer>() : new HashSet<Integer>(networkConfig.getOutboundPorts());
        if (portDefinitions.isEmpty() && ports.isEmpty()) {
            return Collections.emptySet();
        }
        if (portDefinitions.contains("*") || portDefinitions.contains("0")) {
            return Collections.emptySet();
        }
        for (String string : portDefinitions) {
            String[] portDefs;
            String[] stringArray = portDefs = string.split("[,; ]");
            int n = portDefs.length;
            int n2 = 0;
            while (n2 < n) {
                String def = stringArray[n2];
                int dashPos = (def = def.trim()).indexOf(45);
                if (dashPos > 0) {
                    int start = Integer.parseInt(def.substring(0, dashPos));
                    int end = Integer.parseInt(def.substring(dashPos + 1));
                    int port = start;
                    while (port <= end) {
                        ports.add(port);
                        ++port;
                    }
                } else {
                    ports.add(Integer.parseInt(def));
                }
                ++n2;
            }
        }
        if (ports.contains(0)) {
            return Collections.emptySet();
        }
        return ports;
    }
}

