/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.impl.monitor.LocalSemaphoreOperationStatsImpl;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalSemaphoreOperationStats;
import java.util.concurrent.atomic.AtomicLong;

public class SemaphoreOperationsCounter
extends OperationsCounterSupport<LocalSemaphoreOperationStats> {
    private static final LocalSemaphoreOperationStats empty = new LocalSemaphoreOperationStatsImpl();
    private OperationsCounterSupport.OperationCounter modified = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter nonModified = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter acquires = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter nonAcquires = new OperationsCounterSupport.OperationCounter(this);
    private AtomicLong rejectedAcquires = new AtomicLong();
    private AtomicLong permitsAcquired = new AtomicLong();
    private AtomicLong permitsReleased = new AtomicLong();
    private AtomicLong permitsAttached = new AtomicLong();
    private AtomicLong permitsDetached = new AtomicLong();
    private AtomicLong permitsReduced = new AtomicLong();

    public SemaphoreOperationsCounter() {
    }

    public SemaphoreOperationsCounter(long interval) {
        super(interval);
    }

    public void incrementModified(long elapsed) {
        this.modified.count(elapsed);
        this.publishSubResult();
    }

    public void incrementNonModified(long elapsed) {
        this.nonModified.count(elapsed);
        this.publishSubResult();
    }

    public void incrementAcquires(long elapsed, int permits, boolean attached) {
        this.acquires.count(elapsed);
        this.permitsAcquired.addAndGet(permits);
        if (attached) {
            this.permitsAttached.addAndGet(permits);
        }
        this.publishSubResult();
    }

    public void incrementRejectedAcquires(long elapsed) {
        this.acquires.count(elapsed);
        this.rejectedAcquires.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReleases(long elapsed, int permits, boolean detached) {
        this.permitsReleased.addAndGet(permits);
        if (detached) {
            this.incrementNonAcquires(elapsed, -permits);
        } else {
            this.incrementNonAcquires(elapsed, 0);
        }
    }

    public void incrementNonAcquires(long elapsed, int attachedDelta) {
        this.nonAcquires.count(elapsed);
        if (attachedDelta > 0) {
            this.permitsAttached.addAndGet(attachedDelta);
        } else if (attachedDelta < 0) {
            this.permitsDetached.addAndGet(-attachedDelta);
        }
        this.publishSubResult();
    }

    public void incrementPermitsReduced(long elapsed, int reduction) {
        this.permitsReduced.addAndGet(reduction);
        this.incrementNonAcquires(elapsed, 0);
    }

    @Override
    LocalSemaphoreOperationStatsImpl aggregateSubCounterStats() {
        LocalSemaphoreOperationStatsImpl stats = new LocalSemaphoreOperationStatsImpl();
        stats.periodStart = ((SemaphoreOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        for (Object obj : this.listOfSubCounters) {
            SemaphoreOperationsCounter sub = (SemaphoreOperationsCounter)obj;
            stats.acquires.add(sub.acquires.count.get(), sub.acquires.totalLatency.get());
            stats.nonAcquires.add(sub.nonAcquires.count.get(), sub.nonAcquires.totalLatency.get());
            stats.numberOfRejectedAcquires += sub.rejectedAcquires.get();
            stats.numberOfPermitsAcquired += sub.permitsAcquired.get();
            stats.numberOfPermitsReleased += sub.permitsReleased.get();
            stats.numberOfPermitsAttached += sub.permitsAttached.get();
            stats.numberOfPermitsDetached += sub.permitsDetached.get();
            stats.numberOfPermitsReduced += sub.permitsReduced.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    SemaphoreOperationsCounter getAndReset() {
        SemaphoreOperationsCounter newOne = new SemaphoreOperationsCounter();
        newOne.acquires.set(this.acquires.copyAndReset());
        newOne.nonAcquires.set(this.nonAcquires.copyAndReset());
        newOne.rejectedAcquires.set(this.rejectedAcquires.getAndSet(0L));
        newOne.permitsAcquired.set(this.permitsAcquired.getAndSet(0L));
        newOne.permitsReleased.set(this.permitsReleased.getAndSet(0L));
        newOne.permitsAttached.set(this.permitsAttached.getAndSet(0L));
        newOne.permitsDetached.set(this.permitsDetached.getAndSet(0L));
        newOne.permitsReduced.set(this.permitsReduced.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    @Override
    LocalSemaphoreOperationStats getThis() {
        LocalSemaphoreOperationStatsImpl stats = new LocalSemaphoreOperationStatsImpl();
        stats.periodStart = this.startTime;
        LocalSemaphoreOperationStatsImpl localSemaphoreOperationStatsImpl = stats;
        localSemaphoreOperationStatsImpl.getClass();
        stats.acquires = new LocalOperationStatsSupport.OperationStat(localSemaphoreOperationStatsImpl, this.acquires.count.get(), this.acquires.totalLatency.get());
        LocalSemaphoreOperationStatsImpl localSemaphoreOperationStatsImpl2 = stats;
        localSemaphoreOperationStatsImpl2.getClass();
        stats.nonAcquires = new LocalOperationStatsSupport.OperationStat(localSemaphoreOperationStatsImpl2, this.nonAcquires.count.get(), this.nonAcquires.totalLatency.get());
        stats.numberOfRejectedAcquires = this.rejectedAcquires.get();
        stats.numberOfPermitsAcquired = this.permitsAcquired.get();
        stats.numberOfPermitsReleased = this.permitsReleased.get();
        stats.numberOfPermitsAttached = this.permitsAttached.get();
        stats.numberOfPermitsDetached = this.permitsDetached.get();
        stats.numberOfPermitsReduced = this.permitsReduced.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalSemaphoreOperationStats getEmpty() {
        return empty;
    }
}

