/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.spring;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.source.MonitorSource;
import org.javasimon.source.StopwatchTemplate;
import org.javasimon.spring.SpringStopwatchSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonitoringInterceptor
implements MethodInterceptor,
Serializable {
    private final StopwatchTemplate<MethodInvocation> stopwatchTemplate;

    public MonitoringInterceptor(MonitorSource<MethodInvocation, Stopwatch> stopwatchSource) {
        this.stopwatchTemplate = new StopwatchTemplate(stopwatchSource);
    }

    public MonitoringInterceptor(Manager manager) {
        this((MonitorSource<MethodInvocation, Stopwatch>)new SpringStopwatchSource(manager).cache());
    }

    public MonitoringInterceptor() {
        this((MonitorSource<MethodInvocation, Stopwatch>)new SpringStopwatchSource(SimonManager.manager()).cache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Split split = this.stopwatchTemplate.start((Object)invocation);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.stopwatchTemplate.stop(split);
        }
    }
}

