/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.dece;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TrickPlayBox
extends AbstractFullBox {
    public static final String TYPE = "trik";
    private List<Entry> entries = new ArrayList<Entry>();

    public TrickPlayBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return this.entries.size();
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        for (Entry entry : this.entries) {
            os.write(entry.value);
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        for (long remainingBytes = size - 4L; remainingBytes > 0L; --remainingBytes) {
            this.entries.add(new Entry(in.readUInt8()));
        }
    }

    public static class Entry {
        private int value;

        public Entry(int value) {
            this.value = value;
        }

        public int getPicType() {
            return this.value >> 6 & 3;
        }

        public void setPicType(int picType) {
            this.value = (picType & 3) << 6 | this.value;
        }

        public int getDependencyLevel() {
            return this.value & 0x3F;
        }

        public void setDependencyLevel(int dependencyLevel) {
            this.value = dependencyLevel & 0x3F | this.value;
        }
    }
}

