/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MediaProvider
implements Serializable {
    private static final long serialVersionUID = -258215809702057490L;
    private static final Map<String, MediaProvider> instances = new HashMap<String, MediaProvider>();
    public static MediaProvider IMG_LY = new MediaProvider("IMG_LY");
    public static MediaProvider PLIXI;
    public static MediaProvider LOCKERZ;
    public static MediaProvider TWIPPLE;
    public static MediaProvider TWITGOO;
    public static MediaProvider TWITPIC;
    public static MediaProvider YFROG;
    public static MediaProvider MOBYPICTURE;
    public static MediaProvider TWIPL;
    public static MediaProvider POSTEROUS;
    private final String name;

    private MediaProvider() {
        throw new AssertionError();
    }

    MediaProvider(String name) {
        this.name = name;
        instances.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaProvider device = (MediaProvider)o;
        return this.name.equals(device.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private static MediaProvider getInstance(String name) {
        return instances.get(name);
    }

    private Object readResolve() throws ObjectStreamException {
        return MediaProvider.getInstance(this.name);
    }

    static {
        LOCKERZ = PLIXI = new MediaProvider("PLIXI");
        TWIPPLE = new MediaProvider("TWIPPLE");
        TWITGOO = new MediaProvider("TWITGOO");
        TWITPIC = new MediaProvider("TWITPIC");
        YFROG = new MediaProvider("YFROG");
        MOBYPICTURE = new MediaProvider("MOBYPICTURE");
        TWIPL = new MediaProvider("TWIPL");
        POSTEROUS = new MediaProvider("POSTEROUS");
    }
}

