/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.AccountSettings;
import twitter4j.AccountSettingsJSONImpl;
import twitter4j.AccountTotals;
import twitter4j.AccountTotalsJSONImpl;
import twitter4j.Category;
import twitter4j.CategoryJSONImpl;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Friendship;
import twitter4j.FriendshipJSONImpl;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.IDsJSONImpl;
import twitter4j.LanguageJSONImpl;
import twitter4j.Location;
import twitter4j.LocationJSONImpl;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.PlaceJSONImpl;
import twitter4j.ProfileImage;
import twitter4j.ProfileImageImpl;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.QueryResultJSONImpl;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RelatedResults;
import twitter4j.RelatedResultsJSONImpl;
import twitter4j.Relationship;
import twitter4j.RelationshipJSONImpl;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.SavedSearch;
import twitter4j.SavedSearchJSONImpl;
import twitter4j.SimilarPlaces;
import twitter4j.SimilarPlacesImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.TrendsJSONImpl;
import twitter4j.Twitter;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterAPIConfigurationJSONImpl;
import twitter4j.TwitterAPIMonitor;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.api.HelpMethods;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.util.T4JInternalStringUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterImpl
extends TwitterBaseImpl
implements Twitter {
    private static final long serialVersionUID = -1486360080128882436L;
    private final HttpParameter INCLUDE_ENTITIES;
    private final HttpParameter INCLUDE_RTS;

    TwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.INCLUDE_ENTITIES = new HttpParameter("include_entities", conf.isIncludeEntitiesEnabled());
        this.INCLUDE_RTS = new HttpParameter("include_rts", conf.isIncludeRTsEnabled());
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (null != params1 && null != params2) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (null != params1) {
            return params1;
        }
        return params2;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (null != params1 && null != params2) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (null != params1) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        try {
            return new QueryResultJSONImpl(this.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("search.json").toString(), query.asHttpParameterArray()), this.conf);
        }
        catch (TwitterException te) {
            if (404 == te.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw te;
        }
    }

    @Override
    public Trends getTrends() throws TwitterException {
        return new TrendsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends.json").toString()), this.conf);
    }

    @Override
    public Trends getCurrentTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/current.json").toString()), this.conf.isJSONStoreEnabled()).get(0);
    }

    @Override
    public Trends getCurrentTrends(boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/current.json").append(excludeHashTags ? "?exclude=hashtags" : "").toString()), this.conf.isJSONStoreEnabled()).get(0);
    }

    @Override
    public List<Trends> getDailyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/daily.json").toString()), this.conf.isJSONStoreEnabled());
    }

    @Override
    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/daily.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()), this.conf.isJSONStoreEnabled());
    }

    private String toDateStr(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    @Override
    public List<Trends> getWeeklyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/weekly.json").toString()), this.conf.isJSONStoreEnabled());
    }

    @Override
    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/weekly.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()), this.conf.isJSONStoreEnabled());
    }

    @Override
    public ResponseList<Status> getPublicTimeline() throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/public_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public ResponseList<Status> getFriendsTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getFriendsTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray())), this.conf);
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray())), this.conf);
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray())), this.conf);
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId) throws TwitterException {
        return this.getUserTimeline(userId, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray())), this.conf);
    }

    @Override
    public ResponseList<Status> getMentions() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&include_rts=").append(this.conf.isIncludeRTsEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getMentions(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json").toString(), this.mergeParameters(new HttpParameter[]{this.INCLUDE_RTS, this.INCLUDE_ENTITIES}, paging.asPostParameterArray())), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedByMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedByMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedToMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedToMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedToUser(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_ENTITIES})), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedToUser(long userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_ENTITIES})), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedByUser(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_ENTITIES})), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweetedByUser(long userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_user.json").toString(), this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_ENTITIES})), this.conf);
    }

    @Override
    public ResponseList<User> getRetweetedBy(long statusId) throws TwitterException {
        return this.getRetweetedBy(statusId, new Paging(1, 100));
    }

    @Override
    public ResponseList<User> getRetweetedBy(long statusId, Paging paging) throws TwitterException {
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by.json").toString(), paging.asPostParameterArray()), this.conf);
    }

    @Override
    public IDs getRetweetedByIDs(long statusId) throws TwitterException {
        return this.getRetweetedByIDs(statusId, new Paging(1, 100));
    }

    @Override
    public IDs getRetweetedByIDs(long statusId, Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/").append(statusId).append("/retweeted_by/ids.json").toString(), paging.asPostParameterArray()), this.conf);
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return new StatusJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/show/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public Status updateStatus(StatusUpdate latestStatus) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), this.mergeParameters(latestStatus.asHttpParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/destroy/").append(statusId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweet/").append(statusId).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets/").append(statusId).append(".json?count=100&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return new UserJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User showUser(long userId) throws TwitterException {
        return new UserJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public ResponseList<User> lookupUsers(String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", T4JInternalStringUtil.join(screenNames)), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public ResponseList<User> lookupUsers(long[] ids) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("user_id", T4JInternalStringUtil.join(ids)), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/search.json").toString(), new HttpParameter[]{new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions.json").toString()), this.conf);
    }

    @Override
    public ResponseList<User> getUserSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions/").append(categorySlug).append(".json").toString());
        try {
            return UserJSONImpl.createUserList(res.asJSONObject().getJSONArray("users"), res, this.conf);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public ResponseList<User> getMemberSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions/").append(categorySlug).append("/members.json").toString());
        return UserJSONImpl.createUserList(res.asJSONArray(), res, this.conf);
    }

    @Override
    public ProfileImage getProfileImage(String screenName, ProfileImage.ImageSize size) throws TwitterException {
        return new ProfileImageImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/profile_image/").append(screenName).append(".json?size=").append(size.getName()).toString()));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(long userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&cursor=").append(cursor).toString(), null), this.conf);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(long userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public UserList createUserList(String listName, boolean isPublicList, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("name", listName));
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (description != null) {
            httpParams.add(new HttpParameter("description", description));
        }
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/create.json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()])), this.conf);
    }

    @Override
    public UserList updateUserList(int listId, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("list_id", listId));
        if (newListName != null) {
            httpParams.add(new HttpParameter("name", newListName));
        }
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (newDescription != null) {
            httpParams.add(new HttpParameter("description", newDescription));
        }
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/update.json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()])), this.conf);
    }

    @Override
    public PagableResponseList<UserList> getUserLists(String listOwnerScreenName, long cursor) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists.json?screen_name=").append(listOwnerScreenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<UserList> getUserLists(long listOwnerUserId, long cursor) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists.json?user_id=").append(listOwnerUserId).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public UserList showUserList(String listOwnerScreenName, int id) throws TwitterException {
        return this.showUserList(id);
    }

    @Override
    public UserList showUserList(int listId) throws TwitterException {
        return new UserListJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/show.json?list_id=").append(listId).toString()), this.conf);
    }

    @Override
    public UserList destroyUserList(int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/destroy.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId)}), this.conf);
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String listOwnerScreenName, int id, Paging paging) throws TwitterException {
        return this.getUserListStatuses(id, paging);
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long listOwnerId, int id, Paging paging) throws TwitterException {
        return this.getUserListStatuses(id, paging);
    }

    @Override
    public ResponseList<Status> getUserListStatuses(int listId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/statuses.json").toString(), this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "per_page"), new HttpParameter[]{new HttpParameter("list_id", listId), this.INCLUDE_ENTITIES, this.INCLUDE_RTS})), this.conf);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/memberships.json?screen_name=").append(listMemberScreenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listOwnerScreenName, long cursor) throws TwitterException {
        return UserListJSONImpl.createPagableUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/subscriptions.json?screen_name=").append(listOwnerScreenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public ResponseList<UserList> getAllUserLists(String screenName) throws TwitterException {
        return UserListJSONImpl.createUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/all.json?screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public ResponseList<UserList> getAllUserLists(long userId) throws TwitterException {
        return UserListJSONImpl.createUserListList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/all.json?user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        return this.getUserListMembers(listId, cursor);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long listOwnerId, int listId, long cursor) throws TwitterException {
        return this.getUserListMembers(listId, cursor);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(int listId, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members.json?list_id=").append(listId).append("&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public UserList addUserListMember(int listId, long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members/create.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("list_id", listId)}), this.conf);
    }

    @Override
    public UserList addUserListMembers(int listId, long[] userIds) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members/create_all.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("user_id", T4JInternalStringUtil.join(userIds))}), this.conf);
    }

    @Override
    public UserList addUserListMembers(int listId, String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members/create_all.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("screen_name", T4JInternalStringUtil.join(screenNames))}), this.conf);
    }

    @Override
    public UserList deleteUserListMember(int listId, long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members/destroy.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("user_id", userId)}), this.conf);
    }

    @Override
    public User checkUserListMembership(String listOwnerScreenName, int listId, long userId) throws TwitterException {
        return this.showUserListMembership(listId, userId);
    }

    @Override
    public User showUserListMembership(int listId, long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/members/show.json?list_id=").append(listId).append("&user_id=").append(userId).append("&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        return this.getUserListSubscribers(listId, cursor);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(int listId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/subscribers.json?list_id=").append(listId).append("&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public UserList subscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json").toString()), this.conf);
    }

    @Override
    public UserList createUserListSubscription(int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/subscribers/create.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId)}), this.conf);
    }

    @Override
    public UserList unsubscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        return this.destroyUserListSubscription(listId);
    }

    @Override
    public UserList destroyUserListSubscription(int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/subscribers/destroy.json").toString(), new HttpParameter[]{new HttpParameter("list_id", listId)}), this.conf);
    }

    @Override
    public User checkUserListSubscription(String listOwnerScreenName, int listId, long userId) throws TwitterException {
        return this.showUserListSubscription(listId, userId);
    }

    @Override
    public User showUserListSubscription(int listId, long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("lists/subscribers/show.json?list_id=").append(listId).append("&user_id=").append(userId).append("&include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json").toString(), this.mergeParameters(paging.asPostParameterArray(), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public DirectMessage sendDirectMessage(String screenName, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("text", text), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public DirectMessage sendDirectMessage(long userId, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("text", text), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public DirectMessage destroyDirectMessage(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/destroy/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public DirectMessage showDirectMessage(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/show/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User createFriendship(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).append("&follow=").append(follow).toString()), this.conf);
    }

    @Override
    public User createFriendship(long userId, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).append("&follow=").append(follow).toString()), this.conf);
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User destroyFriendship(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public boolean existsFriendship(String userA, String userB) throws TwitterException {
        return -1 != this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/exists.json").toString(), HttpParameter.getParameterArray("user_a", userA, "user_b", userB)).asString().indexOf("true");
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return new RelationshipJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName)), this.conf);
    }

    @Override
    public Relationship showFriendship(long sourceId, long targetId) throws TwitterException {
        return new RelationshipJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), new HttpParameter[]{new HttpParameter("source_id", sourceId), new HttpParameter("target_id", targetId)}), this.conf);
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/incoming.json?cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/outgoing.json?cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return FriendshipJSONImpl.createFriendshipList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/lookup.json?screen_name=").append(T4JInternalStringUtil.join(screenNames)).toString()), this.conf);
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(long[] ids) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return FriendshipJSONImpl.createFriendshipList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/lookup.json?user_id=").append(T4JInternalStringUtil.join(ids)).toString()), this.conf);
    }

    @Override
    public Relationship updateFriendship(String screenName, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelationshipJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/update.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", enableDeviceNotification)}), this.conf);
    }

    @Override
    public Relationship updateFriendship(long userId, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelationshipJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/update.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", enableDeviceNotification)}), this.conf);
    }

    @Override
    public IDs getNoRetweetIds() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/no_retweet_ids.json").toString()), this.conf);
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString()), this.conf);
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        return super.fillInIDAndScreenName();
    }

    @Override
    public RateLimitStatus getRateLimitStatus() throws TwitterException {
        return new RateLimitStatusJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/rate_limit_status.json").toString()), this.conf);
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        profile.add(this.INCLUDE_ENTITIES);
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile.json").toString(), profile.toArray(new HttpParameter[profile.size()])), this.conf);
    }

    @Override
    public AccountTotals getAccountTotals() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new AccountTotalsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/totals.json").toString()), this.conf);
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new AccountSettingsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/settings.json").toString()), this.conf);
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> colors = new ArrayList<HttpParameter>(6);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        colors.add(this.INCLUDE_ENTITIES);
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_colors.json").toString(), colors.toArray(new HttpParameter[colors.size()])), this.conf);
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (null != color) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public User updateProfileImage(InputStream image) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_image.json").toString(), new HttpParameter[]{new HttpParameter("image", "image", image), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.checkFileValidity(image);
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_background_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image), new HttpParameter("tile", tile), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public User updateProfileBackgroundImage(InputStream image, boolean tile) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_background_image.json").toString(), new HttpParameter[]{new HttpParameter("image", "image", image), new HttpParameter("tile", tile), this.INCLUDE_ENTITIES}), this.conf);
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(new StringBuffer().append(image).append(" is not found.").toString()));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(new StringBuffer().append(image).append(" is not a file.").toString()));
        }
    }

    @Override
    public ResponseList<Status> getFavorites() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getFavorites(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json").toString(), new HttpParameter[]{new HttpParameter("page", page), this.INCLUDE_ENTITIES}), this.conf);
    }

    @Override
    public ResponseList<Status> getFavorites(String id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<Status> getFavorites(String id, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json").toString(), this.mergeParameters(HttpParameter.getParameterArray("page", page), this.INCLUDE_ENTITIES)), this.conf);
    }

    @Override
    public Status createFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/create/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public Status destroyFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/destroy/").append(id).append(".json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public User enableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User enableNotification(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public User disableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User disableNotification(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public User createBlock(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public User destroyBlock(String screen_name) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screen_name).toString()), this.conf);
    }

    @Override
    public User destroyBlock(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public boolean existsBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?screen_name=").append(screenName).toString()).asString().indexOf("You are not blocking this user.");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public boolean existsBlock(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?user_id=").append(userId).toString()).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public ResponseList<User> getBlockingUsers() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).toString()), this.conf);
    }

    @Override
    public ResponseList<User> getBlockingUsers(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&page=").append(page).toString()), this.conf);
    }

    @Override
    public IDs getBlockingUsersIDs() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new IDsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking/ids.json").toString()), this.conf);
    }

    @Override
    public User reportSpam(long userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&user_id=").append(userId).toString()), this.conf);
    }

    @Override
    public User reportSpam(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?include_entities=").append(this.conf.isIncludeEntitiesEnabled()).append("&screen_name=").append(screenName).toString()), this.conf);
    }

    @Override
    public List<SavedSearch> getSavedSearches() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return SavedSearchJSONImpl.createSavedSearchList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches.json").toString()), this.conf);
    }

    @Override
    public SavedSearch showSavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/show/").append(id).append(".json").toString()), this.conf);
    }

    @Override
    public SavedSearch createSavedSearch(String query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/create.json").toString(), new HttpParameter[]{new HttpParameter("query", query)}), this.conf);
    }

    @Override
    public SavedSearch destroySavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/destroy/").append(id).append(".json").toString()), this.conf);
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return LocationJSONImpl.createLocationList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString()), this.conf);
    }

    @Override
    public ResponseList<Location> getAvailableTrends(GeoLocation location) throws TwitterException {
        return LocationJSONImpl.createLocationList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString(), new HttpParameter[]{new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude())}), this.conf);
    }

    @Override
    public Trends getLocationTrends(int woeid) throws TwitterException {
        return new TrendsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/").append(woeid).append(".json").toString()), this.conf);
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/search.json").toString(), query.asHttpParameterArray()), this.conf);
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public SimilarPlaces getSimilarPlaces(GeoLocation location, String name, String containedWithin, String streetAddress) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        params.add(new HttpParameter("name", name));
        if (null != containedWithin) {
            params.add(new HttpParameter("contained_within", containedWithin));
        }
        if (null != streetAddress) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return SimilarPlacesImpl.createSimilarPlaces(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/similar_places.json").toString(), params.toArray(new HttpParameter[params.size()])), this.conf);
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/reverse_geocode.json").toString(), query.asHttpParameterArray()), this.conf);
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public Place getGeoDetails(String id) throws TwitterException {
        return new PlaceJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/id/").append(id).append(".json").toString()), this.conf);
    }

    @Override
    public Place createPlace(String name, String containedWithin, String token, GeoLocation location, String streetAddress) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("contained_within", containedWithin));
        params.add(new HttpParameter("token", token));
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        if (null != streetAddress) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return new PlaceJSONImpl(this.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/place.json").toString(), params.toArray(new HttpParameter[params.size()])), this.conf);
    }

    @Override
    public String getTermsOfService() throws TwitterException {
        try {
            return this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("legal/tos.json").toString()).asJSONObject().getString("tos");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public String getPrivacyPolicy() throws TwitterException {
        try {
            return this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("legal/privacy.json").toString()).asJSONObject().getString("privacy");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public RelatedResults getRelatedResults(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new RelatedResultsJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("related_results/show/").append(Long.toString(statusId)).append(".json").toString()), this.conf);
    }

    @Override
    public boolean test() throws TwitterException {
        return -1 != this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("help/test.json").toString()).asString().indexOf("ok");
    }

    @Override
    public TwitterAPIConfiguration getAPIConfiguration() throws TwitterException {
        return new TwitterAPIConfigurationJSONImpl(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("help/configuration.json").toString()), this.conf);
    }

    @Override
    public ResponseList<HelpMethods.Language> getLanguages() throws TwitterException {
        return LanguageJSONImpl.createLanguageList(this.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("help/languages.json").toString()), this.conf);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterImpl twitter = (TwitterImpl)o;
        if (!this.INCLUDE_ENTITIES.equals(twitter.INCLUDE_ENTITIES)) {
            return false;
        }
        return this.INCLUDE_RTS.equals(twitter.INCLUDE_RTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url) throws TwitterException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url, HttpParameter[] parameters) throws TwitterException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, parameters, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, parameters, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url) throws TwitterException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, HttpParameter[] parameters) throws TwitterException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, parameters, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, parameters, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse delete(String url) throws TwitterException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.INCLUDE_ENTITIES.hashCode();
        result = 31 * result + this.INCLUDE_RTS.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("TwitterImpl{INCLUDE_ENTITIES=").append(this.INCLUDE_ENTITIES).append(", INCLUDE_RTS=").append(this.INCLUDE_RTS).append('}').toString();
    }
}

