/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class MS {
    private int[] adaptedGs;
    private int[] qsBc;
    private int m;
    private Pattern[] pat;

    private static int[] computeMinShift(char[] x) {
        int[] minShift = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            int j;
            for (j = i - 1; j >= 0 && x[i] != x[j]; --j) {
            }
            minShift[i] = i - j;
        }
        return minShift;
    }

    private static void orderPattern(char[] x, Pattern[] pat, int[] minShift) {
        for (int i = 0; i < x.length; ++i) {
            Pattern ptrn = new Pattern();
            ptrn.loc = i;
            ptrn.c = x[i];
            pat[i] = ptrn;
        }
        MS.qsortPtrn(pat, 0, x.length - 1, minShift);
    }

    private static void qsortPtrn(Pattern[] pat, int low, int n, int[] minShift) {
        int lo = low;
        int hi = n;
        if (lo >= n) {
            return;
        }
        Pattern mid = pat[(lo + hi) / 2];
        while (lo < hi) {
            while (lo < hi && MS.maxShiftPcmp(pat[lo], mid, minShift) < 0) {
                ++lo;
            }
            while (lo < hi && MS.maxShiftPcmp(pat[hi], mid, minShift) > 0) {
                --hi;
            }
            if (lo >= hi) continue;
            Pattern T = pat[lo];
            pat[lo] = pat[hi];
            pat[hi] = T;
        }
        if (hi < lo) {
            int T = hi;
            hi = lo;
            lo = T;
        }
        MS.qsortPtrn(pat, low, lo, minShift);
        MS.qsortPtrn(pat, lo == low ? lo + 1 : lo, n, minShift);
    }

    private static int maxShiftPcmp(Pattern pat1, Pattern pat2, int[] minShift) {
        int dsh = minShift[pat2.loc] - minShift[pat1.loc];
        return dsh != 0 ? dsh : pat2.loc - pat1.loc;
    }

    private static void preQsBc(char[] x, int[] qsBc) {
        int i;
        int m = x.length;
        for (i = 0; i < qsBc.length; ++i) {
            qsBc[i] = m + 1;
        }
        for (i = 0; i < m; ++i) {
            qsBc[x[i]] = m - i;
        }
    }

    private static int matchShift(char[] x, int ploc, int lshift, Pattern[] pat) {
        while (lshift < x.length) {
            int j;
            int i = ploc;
            while (--i >= 0 && ((j = pat[i].loc - lshift) < 0 || pat[i].c == x[j])) {
            }
            if (i < 0) break;
            ++lshift;
        }
        return lshift;
    }

    private static void preAdaptedGs(char[] x, int[] adaptedGs, Pattern[] pat) {
        int ploc;
        int lshift = 1;
        adaptedGs[0] = 1;
        for (ploc = 1; ploc <= x.length; ++ploc) {
            adaptedGs[ploc] = lshift = MS.matchShift(x, ploc, lshift, pat);
        }
        for (ploc = 0; ploc < x.length; ++ploc) {
            int i;
            lshift = adaptedGs[ploc];
            while (lshift < x.length && (i = pat[ploc].loc - lshift) >= 0 && pat[ploc].c == x[i]) {
                ++lshift;
                lshift = MS.matchShift(x, ploc, lshift, pat);
            }
            adaptedGs[ploc] = lshift;
        }
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        int[] adaptedGs = new int[m + 1];
        int[] qsBc = new int[65536];
        Pattern[] pat = new Pattern[m];
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] minShift = MS.computeMinShift(x);
        MS.orderPattern(x, pat, minShift);
        MS.preQsBc(x, qsBc);
        MS.preAdaptedGs(x, adaptedGs, pat);
        int j = 0;
        while (j <= n - m) {
            int i;
            for (i = 0; i < m && pat[i].c == y[j + pat[i].loc]; ++i) {
            }
            if (i >= m) {
                result.add(j);
            }
            if (j < n - m) {
                j += Math.max(adaptedGs[i], qsBc[y[j + m]]);
                continue;
            }
            j += adaptedGs[i];
        }
        return result;
    }

    public static MS compile(String pattern) {
        char[] x = pattern.toCharArray();
        int m = x.length;
        int[] adaptedGs = new int[m + 1];
        int[] qsBc = new int[65536];
        Pattern[] pat = new Pattern[m];
        int[] minShift = MS.computeMinShift(x);
        MS.orderPattern(x, pat, minShift);
        MS.preQsBc(x, qsBc);
        MS.preAdaptedGs(x, adaptedGs, pat);
        MS ms = new MS();
        ms.adaptedGs = adaptedGs;
        ms.m = m;
        ms.pat = pat;
        ms.qsBc = qsBc;
        return ms;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int j = 0;
        while (j <= n - this.m) {
            int i;
            for (i = 0; i < this.m && this.pat[i].c == y[j + this.pat[i].loc]; ++i) {
            }
            if (i >= this.m) {
                result.add(j);
            }
            if (j < n - this.m) {
                j += Math.max(this.adaptedGs[i], this.qsBc[y[j + this.m]]);
                continue;
            }
            j += this.adaptedGs[i];
        }
        return result;
    }

    private static class Pattern {
        int loc;
        char c;

        private Pattern() {
        }
    }
}

