/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.xpath.xalan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.NodeSequence;
import org.apache.xpath.objects.XObject;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.NamespaceAware;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.contrib.dom.DOM;
import org.jdom2.contrib.dom.Wrapper;
import org.jdom2.filter.Filter;
import org.jdom2.xpath.util.AbstractXPathCompiled;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XalanXPathExpression<T>
extends AbstractXPathCompiled<T>
implements PrefixResolver {
    private final XPath xpath;
    private final VariableStack variables = new VariableStack(){

        public XObject getVariableOrParam(XPathContext xctxt, QName qname) throws TransformerException {
            if (qname == null) {
                throw new IllegalArgumentException("Null qname");
            }
            Object varValue = XalanXPathExpression.this.getVariable(qname.getLocalName(), Namespace.getNamespace((String)qname.getNamespaceURI()));
            if (varValue == null) {
                throw new TransformerException("No such variable " + qname.toNamespacedString());
            }
            return XObject.create((Object)varValue, (XPathContext)xctxt);
        }
    };

    public XalanXPathExpression(String query, Filter<T> filter, Map<String, Object> variables, Namespace[] namespaces) {
        super(query, filter, variables, namespaces);
        try {
            this.xpath = new XPath(query, null, (PrefixResolver)this, 0, null);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Unable to parse: " + query, e);
        }
    }

    private final Node wrap(Object context) {
        if (context == null) {
            return DOM.wrap(new Document(), false);
        }
        if (context instanceof Document) {
            return DOM.wrap((Document)context);
        }
        if (context instanceof Content) {
            switch (((Content)context).getCType()) {
                case CDATA: {
                    return DOM.wrap((CDATA)context);
                }
                case Comment: {
                    return DOM.wrap((Comment)context);
                }
                case DocType: {
                    return DOM.wrap((DocType)context);
                }
                case Element: {
                    return DOM.wrap((Element)context);
                }
                case EntityRef: {
                    return DOM.wrap((EntityRef)context);
                }
                case ProcessingInstruction: {
                    return DOM.wrap((ProcessingInstruction)context);
                }
                case Text: {
                    return DOM.wrap((Text)context);
                }
            }
        }
        if (context instanceof Attribute) {
            return DOM.wrap((Attribute)context);
        }
        throw new IllegalArgumentException("Unable to wrap context: " + context);
    }

    protected List<?> evaluateRawAll(Object context) {
        XPathContext xpathSupport = new XPathContext(false);
        xpathSupport.setVarStack(this.variables);
        Node contextNode = this.wrap(context);
        int ctxtNode = xpathSupport.getDTMHandleFromNode(contextNode);
        try {
            XObject xo = this.xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)this);
            ArrayList<Object> ret = new ArrayList<Object>();
            if (xo instanceof NodeSequence) {
                NodeList nl = ((NodeSequence)xo).nodelist();
                int len = nl.getLength();
                for (int i = 0; i < len; ++i) {
                    Node n = nl.item(i);
                    if (n instanceof Wrapper) {
                        ret.add(((Wrapper)((Object)n)).getWrapped());
                        continue;
                    }
                    if (n instanceof Attr) {
                        Attr nsa = (Attr)n;
                        if ("xmlns".equals(nsa.getLocalName())) {
                            ret.add(Namespace.getNamespace((String)nsa.getValue()));
                            continue;
                        }
                        if (nsa.getName().startsWith("xmlns")) {
                            ret.add(Namespace.getNamespace((String)nsa.getLocalName(), (String)nsa.getValue()));
                            continue;
                        }
                        throw new IllegalStateException("Unexpected Attribute " + nsa.getName() + "=\"" + nsa.getValue() + "\"");
                    }
                    throw new IllegalStateException("Unexpected Node " + n.getNodeName());
                }
            } else {
                ret.add(xo.object());
            }
            return ret;
        }
        catch (TransformerException te) {
            throw new IllegalArgumentException("Unable to process xpath.", te);
        }
    }

    protected Object evaluateRawFirst(Object context) {
        List<?> raw = this.evaluateRawAll(context);
        if (raw.isEmpty()) {
            return null;
        }
        return raw.get(0);
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.getNamespace(prefix).getURI();
    }

    public String getNamespaceForPrefix(String prefix, Node context) {
        Object o;
        if (context == null) {
            return this.getNamespace(prefix).getPrefix();
        }
        if (prefix == null) {
            prefix = "";
        }
        if (context instanceof Wrapper && (o = ((Wrapper)((Object)context)).getWrapped()) instanceof NamespaceAware) {
            for (Namespace ns : ((NamespaceAware)o).getNamespacesInScope()) {
                if (!ns.getPrefix().equals(prefix)) continue;
                return ns.getURI();
            }
        }
        return null;
    }

    public String getBaseIdentifier() {
        return null;
    }

    public boolean handlesNullPrefixes() {
        return false;
    }
}

