/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class ErrorCommand
extends AbstractTextCommand {
    private final String message;
    ByteBuffer response;

    public ErrorCommand(TextCommandConstants.TextCommandType type) {
        this(type, null);
    }

    public ErrorCommand(TextCommandConstants.TextCommandType type, String message) {
        super(type);
        byte[] error = ERROR;
        if (type == TextCommandConstants.TextCommandType.ERROR_CLIENT) {
            error = CLIENT_ERROR;
        } else if (type == TextCommandConstants.TextCommandType.ERROR_SERVER) {
            error = SERVER_ERROR;
        }
        this.message = message;
        byte[] msg = message == null ? null : message.getBytes();
        int total = error.length;
        if (msg != null) {
            total += msg.length;
        }
        this.response = ByteBuffer.allocate(total += 2);
        this.response.put(error);
        if (msg != null) {
            this.response.put(msg);
        }
        this.response.put(RETURN);
        this.response.flip();
    }

    @Override
    public boolean doRead(ByteBuffer cb) {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "ErrorCommand{type=" + (Object)((Object)this.type) + ", msg=" + this.message + '}' + super.toString();
    }
}

