/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.obs.ant.tasks;

import static com.openexchange.obs.api.Distribution.Debian;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.DebianRelease;
import com.openexchange.obs.api.Distribution;

/**
 * From a given repository list the latest Debian release is picked and returned.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class PickLatestDebian extends Task {

    private String repositories;
    private String propertyName;

    public PickLatestDebian() {
        super();
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void execute() throws BuildException {
        if (null == repositories || 0 == repositories.length()) {
            throw new BuildException("Repository list isnot defined.");
        }
        if (null == propertyName || 0 == propertyName.length()) {
            throw new BuildException("Name for property to set is not defined.");
        }
        String[] repos = repositories.split(",");
        DebianRelease newest = null;
        String retval = null;
        for (String repository : repos) {
            try {
                Distribution distribution = Distribution.byRepositoryName(repository);
                if (Debian == distribution) {
                    DebianRelease release = DebianRelease.byRepositoryName(repository);
                    if (null == newest || release.isNewer(newest)) {
                        newest = release;
                        retval = repository;
                    }
                }
            } catch (BuildServiceException e) {
                getProject().log(e.getMessage(), e, Project.MSG_DEBUG);
                // Just continue
            }
        }
        if (null == newest) {
            throw new BuildException("Can not determine newest Debian release out of the following repositories: \"" + repositories + "\"");
        }
        getProject().log("Setting property " + propertyName + " to repository " + retval + '.', Project.MSG_INFO);
        getProject().setInheritedProperty(propertyName, retval);
    }
}
