/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.ajp;

import java.io.CharConversionException;
import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.ajp.AjpConstants;
import org.glassfish.grizzly.http.ajp.AjpHttpRequest;
import org.glassfish.grizzly.http.ajp.AjpHttpResponse;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

final class AjpMessageUtils {
    private static final int[] DEC = HexUtils.getDecBytes();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int BODY_CHUNK_HEADER_SIZE = 7;
    private static final int MAX_BODY_CHUNK_CONTENT_SIZE = 8178;

    AjpMessageUtils() {
    }

    static void decodeRequest(Buffer requestContent, AjpHttpRequest req, boolean tomcatAuthentication) throws IOException {
        int requestURILen;
        byte methodCode;
        int offset = requestContent.position();
        if ((methodCode = requestContent.get(offset++)) != -1) {
            String mName = AjpConstants.methodTransArray[methodCode - 1];
            req.getMethodDC().setString(mName);
        }
        if (!AjpMessageUtils.isNullLength(requestURILen = AjpMessageUtils.readShort(requestContent, offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.getProtocolDC())))) {
            req.getRequestURIRef().init(requestContent, offset + 2, offset + 2 + requestURILen);
        }
        offset += 2 + requestURILen + 1;
        offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.remoteAddr());
        offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.remoteHost());
        offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.localName());
        req.setLocalPort(AjpMessageUtils.readShort(requestContent, offset));
        offset += 2;
        boolean isSSL = requestContent.get(offset++) != 0;
        req.setSecure(isSSL);
        ((AjpHttpResponse)req.getResponse()).setSecure(isSSL);
        offset = AjpMessageUtils.decodeHeaders(requestContent, offset, req);
        AjpMessageUtils.decodeAttributes(requestContent, offset, req, tomcatAuthentication);
        DataChunk valueDC = req.getHeaders().getValue("host");
        AjpMessageUtils.parseHost(valueDC, req);
    }

    private static int decodeAttributes(Buffer requestContent, int offset, AjpHttpRequest req, boolean tomcatAuthentication) {
        DataChunk tmpDataChunk = req.tmpDataChunk;
        boolean moreAttr = true;
        while (moreAttr) {
            byte attributeCode;
            if ((attributeCode = requestContent.get(offset++)) == -1) {
                return offset;
            }
            if (attributeCode == 11) {
                req.setAttribute("javax.servlet.request.key_size", AjpMessageUtils.readShort(requestContent, offset));
                offset += 2;
            }
            if (attributeCode == 10) {
                offset = AjpMessageUtils.setStringAttribute(req, requestContent, offset);
            }
            switch (attributeCode) {
                case 1: {
                    offset = AjpMessageUtils.skipBytes(requestContent, offset);
                    break;
                }
                case 3: {
                    if (tomcatAuthentication) {
                        offset = AjpMessageUtils.skipBytes(requestContent, offset);
                        break;
                    }
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.remoteUser());
                    break;
                }
                case 4: {
                    if (tomcatAuthentication) {
                        offset = AjpMessageUtils.skipBytes(requestContent, offset);
                        break;
                    }
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.authType());
                    break;
                }
                case 5: {
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.getQueryStringDC());
                    break;
                }
                case 6: {
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.instanceId());
                    break;
                }
                case 7: {
                    req.setSecure(true);
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.sslCert());
                    break;
                }
                case 8: {
                    req.setSecure(true);
                    offset = AjpMessageUtils.setStringAttributeValue(req, "javax.servlet.request.cipher_suite", requestContent, offset);
                    break;
                }
                case 9: {
                    req.setSecure(true);
                    offset = AjpMessageUtils.setStringAttributeValue(req, "javax.servlet.request.ssl_session_id", requestContent, offset);
                    break;
                }
                case 12: {
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, tmpDataChunk);
                    req.setSecret(tmpDataChunk.toString());
                    tmpDataChunk.recycle();
                    break;
                }
                case 13: {
                    offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, req.getMethodDC());
                    break;
                }
            }
        }
        return offset;
    }

    private static int decodeHeaders(Buffer requestContent, int offset, AjpHttpRequest req) {
        MimeHeaders headers = req.getHeaders();
        int hCount = AjpMessageUtils.readShort(requestContent, offset);
        offset += 2;
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = AjpMessageUtils.readShort(requestContent, offset);
            int hId = isc & 0xFF;
            DataChunk valueDC = null;
            if (40960 == (isc &= 0xFF00)) {
                offset += 2;
                hName = AjpConstants.headerTransArray[hId - 1];
                valueDC = headers.addValue(hName);
            } else {
                hId = -1;
                int headerNameLen = AjpMessageUtils.readShort(requestContent, offset);
                valueDC = headers.addValue(requestContent, offset += 2, headerNameLen);
                offset += headerNameLen + 1;
            }
            offset = AjpMessageUtils.getBytesToDataChunk(requestContent, offset, valueDC);
            DataChunk headerNameDC = headers.getName(headers.size() - 1);
            if (hId == 8 || hId == -1 && headerNameDC.equalsIgnoreCase("Content-Length")) {
                long cl = Ascii.parseLong((DataChunk)valueDC);
                if (cl >= Integer.MAX_VALUE) continue;
                req.setContentLength((int)cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !headerNameDC.equalsIgnoreCase("Content-Type"))) continue;
            req.setContentType(valueDC.toString());
        }
        return offset;
    }

    private static void parseHost(DataChunk hostDC, AjpHttpRequest request) throws CharConversionException {
        if (hostDC == null) {
            request.setServerPort(request.getLocalPort());
            request.serverName().setString(request.getLocalName());
            return;
        }
        BufferChunk valueBC = hostDC.getBufferChunk();
        int valueS = valueBC.getStart();
        int valueL = valueBC.getEnd() - valueS;
        int colonPos = -1;
        Buffer valueB = valueBC.getBuffer();
        boolean ipv6 = valueB.get(valueS) == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            byte b = valueB.get(i + valueS);
            if (b == 93) {
                bracketClosed = true;
                continue;
            }
            if (b != 58 || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!request.isSecure()) {
                request.setServerPort(80);
            } else {
                request.setServerPort(443);
            }
            request.serverName().setBuffer(valueB, valueS, valueS + valueL);
        } else {
            request.serverName().setBuffer(valueB, valueS, valueS + colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = DEC[valueB.get(i + valueS)];
                if (charValue == -1) {
                    throw new CharConversionException("Invalid char in port: " + valueB.get(i + valueS));
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            request.setServerPort(port);
        }
    }

    private static boolean isNullLength(int length) {
        return length == 65535 || length == -1;
    }

    private static int readShort(Buffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    static int getBytesToDataChunk(Buffer buffer, int offset, DataChunk dataChunk) {
        int bytesStart = offset + 2;
        int length = AjpMessageUtils.readShort(buffer, offset);
        if (AjpMessageUtils.isNullLength(length)) {
            return bytesStart;
        }
        dataChunk.setBuffer(buffer, bytesStart, bytesStart + length);
        return bytesStart + length + 1;
    }

    private static int skipBytes(Buffer buffer, int offset) {
        int bytesStart = offset + 2;
        int length = AjpMessageUtils.readShort(buffer, offset);
        if (AjpMessageUtils.isNullLength(length)) {
            return bytesStart;
        }
        return bytesStart + length + 1;
    }

    private static int setStringAttribute(AjpHttpRequest req, Buffer buffer, int offset) {
        DataChunk tmpDataChunk = req.tmpDataChunk;
        offset = AjpMessageUtils.getBytesToDataChunk(buffer, offset, tmpDataChunk);
        String key = tmpDataChunk.toString();
        tmpDataChunk.recycle();
        offset = AjpMessageUtils.getBytesToDataChunk(buffer, offset, tmpDataChunk);
        String value = tmpDataChunk.toString();
        tmpDataChunk.recycle();
        req.setAttribute(key, value);
        return offset;
    }

    private static int setStringAttributeValue(AjpHttpRequest req, String key, Buffer buffer, int offset) {
        DataChunk tmpDataChunk = req.tmpDataChunk;
        offset = AjpMessageUtils.getBytesToDataChunk(buffer, offset, tmpDataChunk);
        String value = tmpDataChunk.toString();
        tmpDataChunk.recycle();
        req.setAttribute(key, value);
        return offset;
    }

    public static Buffer encodeHeaders(MemoryManager mm, HttpResponsePacket httpResponsePacket) {
        Buffer encodedBuffer = mm.allocate(4096);
        int startPos = encodedBuffer.position();
        encodedBuffer.position(startPos + 4);
        encodedBuffer.put((byte)4);
        encodedBuffer.putShort((short)httpResponsePacket.getStatus());
        encodedBuffer = httpResponsePacket.isCustomReasonPhraseSet() ? AjpMessageUtils.putBytes(mm, encodedBuffer, HttpStatus.filter((DataChunk)httpResponsePacket.getReasonPhraseDC())) : AjpMessageUtils.putBytes(mm, encodedBuffer, httpResponsePacket.getHttpStatus().getReasonPhraseBytes());
        if (httpResponsePacket.isAcknowledgement()) {
            encodedBuffer = AjpMessageUtils.putShort(mm, encodedBuffer, 0);
        } else {
            long contentLength;
            String contentLanguage;
            MimeHeaders headers = httpResponsePacket.getHeaders();
            String contentType = httpResponsePacket.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = httpResponsePacket.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
            if ((contentLength = httpResponsePacket.getContentLength()) >= 0L) {
                Buffer contentLengthBuffer = HttpCodecUtils.getLongAsBuffer((MemoryManager)mm, (long)contentLength);
                headers.setValue("Content-Length").setBuffer(contentLengthBuffer, contentLengthBuffer.position(), contentLengthBuffer.limit());
            }
            int numHeaders = headers.size();
            encodedBuffer = AjpMessageUtils.putShort(mm, encodedBuffer, numHeaders);
            for (int i = 0; i < numHeaders; ++i) {
                DataChunk headerName = headers.getName(i);
                encodedBuffer = AjpMessageUtils.putBytes(mm, encodedBuffer, headerName);
                DataChunk headerValue = headers.getValue(i);
                encodedBuffer = AjpMessageUtils.putBytes(mm, encodedBuffer, headerValue);
            }
        }
        encodedBuffer.put(startPos, (byte)65);
        encodedBuffer.put(startPos + 1, (byte)66);
        encodedBuffer.putShort(startPos + 2, (short)(encodedBuffer.position() - startPos - 4));
        return encodedBuffer;
    }

    public static Buffer appendContentAndTrim(MemoryManager memoryManager, Buffer dstBuffer, Buffer httpContentBuffer) {
        Buffer contentRemainder;
        Buffer resultBuffer = null;
        do {
            contentRemainder = null;
            if (httpContentBuffer.remaining() > 8178) {
                contentRemainder = httpContentBuffer.split(httpContentBuffer.position() + 8178);
            }
            Buffer encodedContentChunk = AjpMessageUtils.appendContentChunkAndTrim(memoryManager, dstBuffer, httpContentBuffer);
            resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, resultBuffer, (Buffer)encodedContentChunk);
            dstBuffer = null;
        } while ((httpContentBuffer = contentRemainder) != null && httpContentBuffer.hasRemaining());
        return resultBuffer;
    }

    private static Buffer appendContentChunkAndTrim(MemoryManager memoryManager, Buffer dstBuffer, Buffer httpContentBuffer) {
        Buffer headerBuffer;
        boolean useDstBufferForHeaders;
        boolean bl = useDstBufferForHeaders = dstBuffer != null && dstBuffer.remaining() >= 7;
        if (useDstBufferForHeaders) {
            headerBuffer = dstBuffer;
        } else {
            if (dstBuffer != null) {
                dstBuffer.trim();
            }
            headerBuffer = memoryManager.allocate(7);
            headerBuffer.allowBufferDispose(true);
        }
        headerBuffer.put((byte)65);
        headerBuffer.put((byte)66);
        headerBuffer.putShort((short)(4 + httpContentBuffer.remaining()));
        headerBuffer.put((byte)3);
        headerBuffer.putShort((short)httpContentBuffer.remaining());
        headerBuffer.trim();
        Buffer resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)headerBuffer, (Buffer)httpContentBuffer);
        Buffer terminatingBuffer = memoryManager.allocate(1);
        terminatingBuffer.allowBufferDispose(true);
        resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)resultBuffer, (Buffer)terminatingBuffer);
        if (!useDstBufferForHeaders && dstBuffer != null) {
            resultBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)dstBuffer, (Buffer)resultBuffer);
        }
        if (resultBuffer.isComposite()) {
            ((CompositeBuffer)resultBuffer).allowInternalBuffersDispose(true);
        }
        return resultBuffer;
    }

    private static Buffer putBytes(MemoryManager memoryManager, Buffer dstBuffer, DataChunk dataChunk) {
        if (dataChunk == null || dataChunk.isNull()) {
            return AjpMessageUtils.putBytes(memoryManager, dstBuffer, EMPTY_BYTE_ARRAY);
        }
        int size = dataChunk.getLength();
        if (dstBuffer.remaining() < size + 2 + 1) {
            dstBuffer = HttpCodecUtils.resizeBuffer((MemoryManager)memoryManager, (Buffer)dstBuffer, (int)(size + 2 + 1));
        }
        dstBuffer.putShort((short)size);
        dstBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)dstBuffer, (DataChunk)dataChunk);
        dstBuffer.put((byte)0);
        return dstBuffer;
    }

    private static Buffer putBytes(MemoryManager memoryManager, Buffer dstBuffer, byte[] bytes) {
        int size = bytes.length;
        if (dstBuffer.remaining() < size + 2 + 1) {
            dstBuffer = HttpCodecUtils.resizeBuffer((MemoryManager)memoryManager, (Buffer)dstBuffer, (int)(size + 2 + 1));
        }
        dstBuffer.putShort((short)size);
        dstBuffer = HttpCodecUtils.put((MemoryManager)memoryManager, (Buffer)dstBuffer, (byte[])bytes);
        dstBuffer.put((byte)0);
        return dstBuffer;
    }

    private static Buffer putShort(MemoryManager memoryManager, Buffer dstBuffer, int value) {
        if (dstBuffer.remaining() < 2) {
            dstBuffer = HttpCodecUtils.resizeBuffer((MemoryManager)memoryManager, (Buffer)dstBuffer, (int)2);
        }
        dstBuffer.putShort((short)value);
        return dstBuffer;
    }
}

