/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.PipedZipBufferFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.DataFormatException;

public class MulticastService
implements Runnable {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private final ILogger logger;
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private final Object sendLock = new Object();
    private volatile boolean running = true;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private List<MulticastListener> lsListeners = new CopyOnWriteArrayList<MulticastListener>();
    final Node node;
    private final PipedZipBufferFactory.InflatingPipedBuffer inflatingBuffer = PipedZipBufferFactory.createInflatingBuffer(65536);
    private final PipedZipBufferFactory.DeflatingPipedBuffer deflatingBuffer = PipedZipBufferFactory.createDeflatingBuffer(65536, 1);

    public MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.node = node;
        this.logger = node.getLogger(MulticastService.class.getName());
        Config config = node.getConfig();
        this.multicastSocket = multicastSocket;
        this.datagramPacketReceive = new DatagramPacket(this.inflatingBuffer.getInputBuffer().array(), 65536);
        this.datagramPacketSend = new DatagramPacket(this.deflatingBuffer.getOutputBuffer().array(), 65536, InetAddress.getByName(config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastGroup()), config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastPort());
        this.running = true;
    }

    public void addMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.add(multicastListener);
    }

    public void removeMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.remove(multicastListener);
    }

    public void stop() {
        try {
            if (!this.running && this.multicastSocket.isClosed()) {
                return;
            }
            try {
                this.multicastSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.running = false;
            if (!this.stopLatch.await(5L, TimeUnit.SECONDS)) {
                this.logger.log(Level.WARNING, "Failed to shutdown MulticastService in 5 seconds!");
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void cleanup() {
        this.running = false;
        try {
            this.inflatingBuffer.destroy();
            this.deflatingBuffer.destroy();
            this.datagramPacketReceive.setData(new byte[0]);
            this.datagramPacketSend.setData(new byte[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stopLatch.countDown();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JoinInfo receive() {
        block9: {
            this.inflatingBuffer.reset();
            try {
                this.multicastSocket.receive(this.datagramPacketReceive);
            }
            catch (IOException ignore) {
                return null;
            }
            this.inflatingBuffer.inflate(this.datagramPacketReceive.getLength());
            byte packetVersion = this.inflatingBuffer.getDataInput().readByte();
            if (packetVersion == Packet.PACKET_VERSION) break block9;
            this.logger.log(Level.FINEST, "Received a JoinRequest with different packet version: " + packetVersion);
            return null;
        }
        try {
            JoinInfo joinInfo = new JoinInfo();
            joinInfo.readData(this.inflatingBuffer.getDataInput());
            return joinInfo;
        }
        catch (Exception e) {
            try {
                if (!(e instanceof EOFException) && !(e instanceof DataFormatException)) {
                    throw e;
                }
                this.logger.log(Level.FINEST, "Received data format is invalid. (An old version of Hazelcast may be running here.)", e);
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinInfo joinInfo) {
        if (!this.running) {
            return;
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.deflatingBuffer.reset();
                this.deflatingBuffer.getDataOutput().writeByte(Packet.PACKET_VERSION);
                joinInfo.writeData(this.deflatingBuffer.getDataOutput());
                int count = this.deflatingBuffer.deflate();
                this.datagramPacketSend.setData(this.deflatingBuffer.getOutputBuffer().array(), 0, count);
                this.multicastSocket.send(this.datagramPacketSend);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "You probably have too long Hazelcast configuration!", e);
            }
        }
    }
}

