/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.input;

import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Element;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.contrib.input.LineNumberElement;
import org.jdom2.input.sax.SAXHandler;
import org.jdom2.input.sax.SAXHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LineNumberSAXHandler
extends SAXHandler {
    public static final SAXHandlerFactory SAXFACTORY = new SAXHandlerFactory(){

        public SAXHandler createSAXHandler(JDOMFactory factory) {
            return new LineNumberSAXHandler();
        }
    };

    public LineNumberSAXHandler() {
        super((JDOMFactory)new MyJDOMFactory());
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        super.startElement(arg0, arg1, arg2, arg3);
        Locator l = this.getDocumentLocator();
        if (l != null) {
            ((LineNumberElement)this.getCurrentElement()).setStartLine(l.getLineNumber());
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        Locator l = this.getDocumentLocator();
        if (l != null) {
            ((LineNumberElement)this.getCurrentElement()).setEndLine(l.getLineNumber());
        }
        super.endElement(arg0, arg1, arg2);
    }

    private static class MyJDOMFactory
    extends DefaultJDOMFactory {
        private MyJDOMFactory() {
        }

        public Element element(int line, int col, String name) {
            return new LineNumberElement(name);
        }

        public Element element(int line, int col, String name, String prefix, String uri) {
            return new LineNumberElement(name, prefix, uri);
        }

        public Element element(int line, int col, String name, Namespace namespace) {
            return new LineNumberElement(name, namespace);
        }

        public Element element(int line, int col, String name, String uri) {
            return new LineNumberElement(name, uri);
        }
    }
}

