/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLink
extends ClickableElement {
    private static final long serialVersionUID = 323745155296983364L;
    public static final String TAG_NAME = "link";
    private WebResponse cachedWebResponse_;

    HtmlLink(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttribute("hreflang");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getRelAttribute() {
        return this.getAttribute("rel");
    }

    public final String getRevAttribute() {
        return this.getAttribute("rev");
    }

    public final String getMediaAttribute() {
        return this.getAttribute("media");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded && this.cachedWebResponse_ == null) {
            HtmlPage page = (HtmlPage)this.getPage();
            WebClient webclient = page.getWebClient();
            URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
            WebRequestSettings request = new WebRequestSettings(url);
            WebRequestSettings referringRequest = page.getWebResponse().getRequestSettings();
            request.setAdditionalHeaders(new HashMap<String, String>(referringRequest.getAdditionalHeaders()));
            this.cachedWebResponse_ = webclient.loadWebResponse(request);
        }
        return this.cachedWebResponse_;
    }
}

