/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;

public class WebSocketProcessorFactory {
    private static WebSocketProcessorFactory factory;
    private WebSocketProcessor webSocketprocessor;

    public static final synchronized WebSocketProcessorFactory getDefault() {
        if (factory == null) {
            factory = new WebSocketProcessorFactory();
        }
        return factory;
    }

    public synchronized WebSocketProcessor getWebSocketProcessor(AtmosphereFramework framework) {
        if (this.webSocketprocessor == null) {
            String webSocketProcessorName = framework.getWebSocketProcessorClassName();
            if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
                try {
                    this.webSocketprocessor = (WebSocketProcessor)Thread.currentThread().getContextClassLoader().loadClass(webSocketProcessorName).newInstance();
                }
                catch (Exception ex) {
                    try {
                        this.webSocketprocessor = (WebSocketProcessor)this.getClass().getClassLoader().loadClass(webSocketProcessorName).newInstance();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
            }
            if (this.webSocketprocessor == null) {
                this.webSocketprocessor = new DefaultWebSocketProcessor(framework);
            }
        }
        return this.webSocketprocessor;
    }

    public synchronized void destroy() {
        if (this.webSocketprocessor != null) {
            this.webSocketprocessor.destroy();
            this.webSocketprocessor = null;
        }
    }
}

