/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.Parser;

public class ParseUtils
implements TikaMimeKeys {
    public static Parser getParser(String mimeType, TikaConfig config) throws TikaException {
        return config.getParser(MediaType.parse(mimeType));
    }

    public static Parser getParser(URL documentUrl, TikaConfig config) throws TikaException {
        String mimetype = config.getMimeRepository().getMimeType(documentUrl).getName();
        return ParseUtils.getParser(mimetype, config);
    }

    public static Parser getParser(File documentFile, TikaConfig config) throws TikaException {
        String mimetype = config.getMimeRepository().getMimeType(documentFile).getName();
        return ParseUtils.getParser(mimetype, config);
    }

    public static String getStringContent(InputStream stream, TikaConfig config, String mimeType) throws TikaException, IOException {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", mimeType);
        return new Tika(config).parseToString(stream, metadata);
    }

    public static String getStringContent(URL documentUrl, TikaConfig config) throws TikaException, IOException {
        return new Tika(config).parseToString(documentUrl);
    }

    public static String getStringContent(URL documentUrl, TikaConfig config, String mimeType) throws TikaException, IOException {
        Metadata metadata = new Metadata();
        TikaInputStream stream = TikaInputStream.get(documentUrl, metadata);
        return new Tika(config).parseToString(stream, metadata);
    }

    public static String getStringContent(File documentFile, TikaConfig config, String mimeType) throws TikaException, IOException {
        Metadata metadata = new Metadata();
        TikaInputStream stream = TikaInputStream.get(documentFile, metadata);
        return new Tika(config).parseToString(stream, metadata);
    }

    public static String getStringContent(File documentFile, TikaConfig config) throws TikaException, IOException {
        return new Tika(config).parseToString(documentFile);
    }
}

