/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOOXMLExtractor
implements OOXMLExtractor {
    static final String RELATION_AUDIO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio";
    static final String RELATION_IMAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    static final String RELATION_OLE_OBJECT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    static final String RELATION_PACKAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    private static final String TYPE_OLE_OBJECT = "application/vnd.openxmlformats-officedocument.oleObject";
    protected POIXMLTextExtractor extractor;
    private final EmbeddedDocumentExtractor embeddedExtractor;
    private final String type;

    public AbstractOOXMLExtractor(ParseContext context, POIXMLTextExtractor extractor, String type) {
        this.extractor = extractor;
        this.type = type;
        EmbeddedDocumentExtractor ex = context.get(EmbeddedDocumentExtractor.class);
        this.embeddedExtractor = ex == null ? new ParsingEmbeddedDocumentExtractor(context) : ex;
    }

    @Override
    public POIXMLDocument getDocument() {
        return this.extractor.getDocument();
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor(this.extractor, this.type);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.buildXHTML(xhtml);
        this.handleEmbeddedParts(handler);
        xhtml.endDocument();
    }

    private void handleEmbeddedParts(ContentHandler handler) throws TikaException, IOException, SAXException {
        try {
            for (PackagePart source : this.getMainDocumentParts()) {
                for (PackageRelationship rel : source.getRelationships()) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    URI uri = rel.getTargetURI();
                    if (uri.getFragment() != null) {
                        try {
                            String u = uri.toString();
                            uri = new URI(u.substring(0, u.indexOf(35)));
                        }
                        catch (URISyntaxException e) {
                            throw new TikaException("Broken OOXML file", e);
                        }
                    }
                    PackagePart target = rel.getPackage().getPart(PackagingURIHelper.createPartName(uri));
                    String type = rel.getRelationshipType();
                    if (RELATION_OLE_OBJECT.equals(type) && TYPE_OLE_OBJECT.equals(target.getContentType())) {
                        this.handleEmbeddedOLE(target, handler);
                        continue;
                    }
                    if (!RELATION_AUDIO.equals(type) && !RELATION_IMAGE.equals(type) && !RELATION_PACKAGE.equals(type) && !RELATION_OLE_OBJECT.equals(type)) continue;
                    this.handleEmbeddedFile(target, handler);
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Broken OOXML file", e);
        }
    }

    private void handleEmbeddedOLE(PackagePart part, ContentHandler handler) throws IOException, SAXException {
        POIFSFileSystem fs = new POIFSFileSystem(part.getInputStream());
        try {
            Metadata metadata = new Metadata();
            TikaInputStream stream = null;
            DirectoryNode root = fs.getRoot();
            OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(root);
            if (root.hasEntry("CONTENTS") && root.hasEntry("\u0001Ole") && root.hasEntry("\u0001CompObj") && root.hasEntry("\u0003ObjInfo")) {
                stream = TikaInputStream.get(fs.createDocumentInputStream("CONTENTS"));
                if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded(stream, new EmbeddedContentHandler(handler), metadata, false);
                }
            } else if (OfficeParser.POIFSDocumentType.OLE10_NATIVE == type) {
                Ole10Native ole = Ole10Native.createFromEmbeddedOleObject(fs);
                metadata.set("resourceName", ole.getLabel());
                byte[] data = ole.getDataBuffer();
                if (data != null) {
                    stream = TikaInputStream.get(data);
                }
                if (stream != null && this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded(stream, new EmbeddedContentHandler(handler), metadata, false);
                }
            } else {
                this.handleEmbeddedFile(part, handler);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Ole10NativeException e) {
            // empty catch block
        }
    }

    protected void handleEmbeddedFile(PackagePart part, ContentHandler handler) throws SAXException, IOException {
        Metadata metadata = new Metadata();
        String name = part.getPartName().getName();
        metadata.set("resourceName", name.substring(name.lastIndexOf(47) + 1));
        metadata.set("Content-Type", part.getContentType());
        if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
            this.embeddedExtractor.parseEmbedded(TikaInputStream.get(part.getInputStream()), new EmbeddedContentHandler(handler), metadata, false);
        }
    }

    protected abstract void buildXHTML(XHTMLContentHandler var1) throws SAXException, XmlException, IOException;

    protected abstract List<PackagePart> getMainDocumentParts() throws TikaException;
}

