/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaConfig {
    private final CompositeParser parser;
    private final MimeTypes mimeTypes;

    public TikaConfig(String file) throws TikaException, IOException, SAXException {
        this(new File(file));
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file));
    }

    public TikaConfig(URL url) throws TikaException, IOException, SAXException {
        this(url, TikaConfig.getContextClassLoader());
    }

    public TikaConfig(URL url, ClassLoader loader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(url.toString()).getDocumentElement(), loader);
    }

    public TikaConfig(InputStream stream) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(stream));
    }

    public TikaConfig(InputStream stream, Parser delegate) throws TikaException, IOException, SAXException {
        this(stream);
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document.getDocumentElement());
    }

    public TikaConfig(Document document, Parser delegate) throws TikaException, IOException {
        this(document);
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        this(element, TikaConfig.getContextClassLoader());
    }

    public TikaConfig(Element element, ClassLoader loader) throws TikaException, IOException {
        this.mimeTypes = TikaConfig.typesFromDomElement(element);
        this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
    }

    public TikaConfig(ClassLoader loader) throws MimeTypeException, IOException {
        this.parser = new DefaultParser(loader);
        this.mimeTypes = MimeTypes.getDefaultMimeTypes();
    }

    public TikaConfig() throws TikaException, IOException {
        ClassLoader loader = TikaConfig.getContextClassLoader();
        String config = System.getProperty("tika.config");
        if (config == null) {
            config = System.getenv("TIKA_CONFIG");
        }
        if (config == null) {
            this.mimeTypes = MimeTypes.getDefaultMimeTypes();
            this.parser = new DefaultParser(this.mimeTypes.getMediaTypeRegistry(), loader);
        } else {
            File file = new File(config);
            InputStream stream = file.isFile() ? new FileInputStream(file) : loader.getResourceAsStream(config);
            if (stream != null) {
                try {
                    Element element = TikaConfig.getBuilder().parse(stream).getDocumentElement();
                    this.mimeTypes = TikaConfig.typesFromDomElement(element);
                    this.parser = TikaConfig.parserFromDomElement(element, this.mimeTypes, loader);
                }
                catch (SAXException e) {
                    throw new TikaException("Specified Tika configuration has syntax errors: " + config, e);
                }
                finally {
                    stream.close();
                }
            } else {
                throw new TikaException("Specified Tika configuration not found: " + config);
            }
        }
    }

    public TikaConfig(Element element, Parser delegate) throws TikaException, IOException {
        this(element);
    }

    private static String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder builder = new StringBuilder();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                builder.append(TikaConfig.getText(list.item(i)));
            }
            return builder.toString();
        }
        return "";
    }

    public Parser getParser(MediaType mimeType) {
        return this.parser.getParsers().get(mimeType);
    }

    public Parser getParser() {
        return this.parser;
    }

    public Map<MediaType, Parser> getParsers() {
        return this.parser.getParsers();
    }

    public MimeTypes getMimeRepository() {
        return this.mimeTypes;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.mimeTypes.getMediaTypeRegistry();
    }

    public static TikaConfig getDefaultConfig() {
        try {
            return new TikaConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read default configuration", e);
        }
        catch (TikaException e) {
            throw new RuntimeException("Unable to access default configuration", e);
        }
    }

    public static TikaConfig getDefaultConfig(Parser delegate) throws TikaException {
        return TikaConfig.getDefaultConfig();
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    private static Element getChild(Element element, String name) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = TikaConfig.class.getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private static MimeTypes typesFromDomElement(Element element) throws TikaException, IOException {
        Element mtr = TikaConfig.getChild(element, "mimeTypeRepository");
        if (mtr != null && mtr.hasAttribute("resource")) {
            return MimeTypesFactory.create(mtr.getAttribute("resource"));
        }
        return MimeTypes.getDefaultMimeTypes();
    }

    private static CompositeParser parserFromDomElement(Element element, MimeTypes mimeTypes, ClassLoader loader) throws TikaException, IOException {
        ArrayList<Parser> parsers = new ArrayList<Parser>();
        NodeList nodes = element.getElementsByTagName("parser");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<?> parserClass = Class.forName(name, true, loader);
                Object instance = parserClass.newInstance();
                if (!(instance instanceof Parser)) {
                    throw new TikaException("Configured class is not a Tika Parser: " + name);
                }
                Parser parser = (Parser)instance;
                NodeList mimes = node.getElementsByTagName("mime");
                if (mimes.getLength() > 0) {
                    HashSet<MediaType> types = new HashSet<MediaType>();
                    for (int j = 0; j < mimes.getLength(); ++j) {
                        String mime = TikaConfig.getText(mimes.item(j));
                        MediaType type = MediaType.parse(mime);
                        if (type == null) {
                            throw new TikaException("Invalid media type name: " + mime);
                        }
                        types.add(type);
                    }
                    parser = ParserDecorator.withTypes(parser, types);
                }
                parsers.add(parser);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Configured parser class not found: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a parser class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a parser class: " + name, e);
            }
        }
        return new CompositeParser(mimeTypes.getMediaTypeRegistry(), parsers);
    }
}

