/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2009-2011 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 * Portions Copyright 2012 OPEN-XCHANGE, licensed under GPL Version 2.
 */
package com.openexchange.http.grizzly.service.http;

import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * Abstract OSGi {@link org.glassfish.grizzly.http.server.HttpHandler}.
 * <p/>
 * Defines locking model for processing and removal of handler.
 *
 * @author Hubert Iwaniuk
 * @author <a href="mailto:marc.arens@open-xchange.com">Marc Arens</a>
 */
public interface OSGiHandler {
    /**
     * Processing lock.
     * <p/>
     * {@link ReentrantReadWriteLock.ReadLock} can be obtained by concurrent threads at the same time.
     *
     * @return Processing lock.
     */
    public ReentrantReadWriteLock.ReadLock getProcessingLock();

    /**
     * Removal lock.
     * <p/>
     * {@link ReentrantReadWriteLock.WriteLock} can be obtained only by one thread, blocks {@link #getProcessingLock()}.
     *
     * @return Removal lock.
     * @see #getProcessingLock()
     * @see ReentrantReadWriteLock.WriteLock
     */
    public ReentrantReadWriteLock.WriteLock getRemovalLock();
}
