/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream.internal.classloading_utils;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends ClassLoader {
    private final Bundle bundle;

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.getBundle().loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException(String.format("Class '%s' could not be load from Bundle[symbolic-name = '%s']", name, this.getBundle().getSymbolicName()));
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected URL findResource(String name) {
        return this.getBundle().getEntry("/" + name);
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> resources = new Vector<URL>();
        URL resource = this.getResource(name);
        if (resource != null) {
            resources.add(resource);
        }
        return resources.elements();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    public String toString() {
        return String.format("BundleClassLoader[bundle-symbolic-name = '%s']", this.getBundle().getSymbolicName());
    }

    public BundleClassLoader(Bundle bundle) {
        this.bundle = bundle;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }
}

