/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.tika.gui.TikaGUI;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParsingTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -557932290014044494L;
    private final TransferHandler delegate;
    private final TikaGUI tika;
    private static DataFlavor uriListFlavor;
    private static DataFlavor urlListFlavor;

    public ParsingTransferHandler(TransferHandler delegate, TikaGUI tika) {
        this.delegate = delegate;
        this.tika = tika;
    }

    @Override
    public boolean canImport(JComponent component, DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.equals(DataFlavor.javaFileListFlavor) && !flavor.equals(uriListFlavor) && !flavor.equals(urlListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        try {
            List<File> files = null;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                files = (List<File>)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            } else if (transferable.isDataFlavorSupported(urlListFlavor)) {
                Object data = transferable.getTransferData(urlListFlavor);
                Metadata metadata = new Metadata();
                InputStream stream = MetadataHelper.getInputStream(new URL(data.toString()), metadata);
                this.tika.importStream(stream, metadata);
            } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                files = ParsingTransferHandler.uriToFileList(transferable.getTransferData(uriListFlavor).toString());
            }
            for (File file : files) {
                Metadata metadata = new Metadata();
                InputStream stream = MetadataHelper.getInputStream(file.toURI().toURL(), metadata);
                this.tika.importStream(stream, metadata);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void exportAsDrag(JComponent arg0, InputEvent arg1, int arg2) {
        this.delegate.exportAsDrag(arg0, arg1, arg2);
    }

    @Override
    public void exportToClipboard(JComponent arg0, Clipboard arg1, int arg2) throws IllegalStateException {
        this.delegate.exportToClipboard(arg0, arg1, arg2);
    }

    @Override
    public int getSourceActions(JComponent arg0) {
        return this.delegate.getSourceActions(arg0);
    }

    @Override
    public Icon getVisualRepresentation(Transferable arg0) {
        return this.delegate.getVisualRepresentation(arg0);
    }

    private static List<File> uriToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                list.add(new File(new URI(s)));
            }
            catch (Exception e) {}
        }
        return list;
    }

    static {
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            urlListFlavor = new DataFlavor("text/plain;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

