/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.fork.ForkParser;
import org.apache.tika.gui.TikaGUI;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.language.ProfilingHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.html.BoilerpipeContentHandler;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaCLI {
    private final OutputType XML = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            return TikaCLI.getTransformerHandler(output, "xml", TikaCLI.this.encoding);
        }
    };
    private final OutputType HTML = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            return TikaCLI.getTransformerHandler(output, "html", TikaCLI.this.encoding);
        }
    };
    private final OutputType TEXT = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            return new BodyContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType NO_OUTPUT = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) {
            return new DefaultHandler();
        }
    };
    private final OutputType TEXT_MAIN = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            return new BoilerpipeContentHandler(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
        }
    };
    private final OutputType METADATA = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new NoDocumentMetHandler(writer);
        }
    };
    private final OutputType LANGUAGE = new OutputType(){

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            final PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            return new ProfilingHandler(){

                public void endDocument() {
                    writer.println(this.getLanguage().getLanguage());
                    writer.flush();
                }
            };
        }
    };
    private final OutputType DETECT = new OutputType(){

        public void process(InputStream stream, OutputStream output) throws Exception {
            PrintWriter writer = new PrintWriter(TikaCLI.getOutputWriter(output, TikaCLI.this.encoding));
            writer.println(TikaCLI.this.detector.detect(stream, TikaCLI.this.metadata).toString());
            writer.flush();
        }
    };
    private ParseContext context;
    private Detector detector;
    private AutoDetectParser parser;
    private Metadata metadata;
    private OutputType type = this.XML;
    private String encoding = null;
    private boolean pipeMode = true;
    private boolean portMode = false;
    private boolean fork = false;

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure(new WriterAppender((Layout)new SimpleLayout(), System.err));
        Logger.getRootLogger().setLevel(Level.INFO);
        TikaCLI cli = new TikaCLI();
        for (int i = 0; i < args.length; ++i) {
            cli.process(args[i]);
        }
        if (cli.pipeMode) {
            cli.process("-");
        }
    }

    public TikaCLI() throws TransformerConfigurationException, IOException, TikaException, SAXException {
        this.context = new ParseContext();
        this.detector = new DefaultDetector();
        this.parser = new AutoDetectParser(this.detector);
        this.context.set(Parser.class, this.parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String arg) throws Exception {
        if (arg.equals("-?") || arg.equals("--help")) {
            this.pipeMode = false;
            this.usage();
        } else if (arg.equals("-v") || arg.equals("--verbose")) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (arg.equals("-g") || arg.equals("--gui")) {
            this.pipeMode = false;
            TikaGUI.main(new String[0]);
        } else if (arg.equals("--list-parser") || arg.equals("--list-parsers")) {
            this.pipeMode = false;
            this.displayParsers(false);
        } else if (arg.equals("--list-parser-detail") || arg.equals("--list-parser-details")) {
            this.pipeMode = false;
            this.displayParsers(true);
        } else if (arg.equals("--list-met-models")) {
            this.pipeMode = false;
            this.displayMetModels();
        } else if (arg.equals("--list-supported-types")) {
            this.pipeMode = false;
            this.displaySupportedTypes();
        } else if (!arg.equals("--container-aware") && !arg.equals("--container-aware-detector")) {
            if (arg.equals("-f") || arg.equals("--fork")) {
                this.fork = true;
            } else if (arg.startsWith("-e")) {
                this.encoding = arg.substring("-e".length());
            } else if (arg.startsWith("--encoding=")) {
                this.encoding = arg.substring("--encoding=".length());
            } else if (arg.equals("-x") || arg.equals("--xml")) {
                this.type = this.XML;
            } else if (arg.equals("-h") || arg.equals("--html")) {
                this.type = this.HTML;
            } else if (arg.equals("-t") || arg.equals("--text")) {
                this.type = this.TEXT;
            } else if (arg.equals("-T") || arg.equals("--text-main")) {
                this.type = this.TEXT_MAIN;
            } else if (arg.equals("-m") || arg.equals("--metadata")) {
                this.type = this.METADATA;
            } else if (arg.equals("-l") || arg.equals("--language")) {
                this.type = this.LANGUAGE;
            } else if (arg.equals("-d") || arg.equals("--detect")) {
                this.type = this.DETECT;
            } else if (arg.equals("-z") || arg.equals("--extract")) {
                this.type = this.NO_OUTPUT;
                this.context.set(EmbeddedDocumentExtractor.class, new FileEmbeddedDocumentExtractor());
            } else if (arg.equals("-p") || arg.equals("--port")) {
                this.portMode = true;
                this.pipeMode = false;
            } else {
                this.pipeMode = false;
                this.metadata = new Metadata();
                if (this.portMode) {
                    new TikaServer(Integer.parseInt(arg)).start();
                } else {
                    if (arg.equals("-")) {
                        TikaInputStream stream = TikaInputStream.get(new CloseShieldInputStream(System.in));
                        try {
                            this.type.process(stream, System.out);
                        }
                        finally {
                            ((InputStream)stream).close();
                        }
                    }
                    File file = new File(arg);
                    URL url = file.isFile() ? file.toURI().toURL() : new URL(arg);
                    TikaInputStream input = TikaInputStream.get(url, this.metadata);
                    try {
                        this.type.process(input, System.out);
                    }
                    finally {
                        ((InputStream)input).close();
                        System.out.flush();
                    }
                }
            }
        }
    }

    private void usage() {
        PrintStream out = System.out;
        out.println("usage: java -jar tika-app.jar [option...] [file|port...]");
        out.println();
        out.println("Options:");
        out.println("    -?  or --help        Print this usage message");
        out.println("    -v  or --verbose     Print debug level messages");
        out.println();
        out.println("    -g  or --gui         Start the Apache Tika GUI");
        out.println("    -s  or --server      Start the Apache Tika server");
        out.println();
        out.println("    -x  or --xml         Output XHTML content (default)");
        out.println("    -h  or --html        Output HTML content");
        out.println("    -t  or --text        Output plain text content");
        out.println("    -T  or --text-main   Output plain text content (main content only)");
        out.println("    -m  or --metadata    Output only metadata");
        out.println("    -l  or --language    Output only language");
        out.println("    -d  or --detect      Detect document type");
        out.println("    -eX or --encoding=X  Use output encoding X");
        out.println("    -z  or --extract     Extract all attachements into current directory");
        out.println();
        out.println("    --list-parsers");
        out.println("         List the available document parsers");
        out.println("    --list-parser-details");
        out.println("         List the available document parsers, and their supported mime types");
        out.println("    --list-met-models");
        out.println("         List the available metadata models, and their supported keys");
        out.println("    --list-supported-types");
        out.println("         List all known media types and related information");
        out.println();
        out.println("Description:");
        out.println("    Apache Tika will parse the file(s) specified on the");
        out.println("    command line and output the extracted text content");
        out.println("    or metadata to standard output.");
        out.println();
        out.println("    Instead of a file name you can also specify the URL");
        out.println("    of a document to be parsed.");
        out.println();
        out.println("    If no file name or URL is specified (or the special");
        out.println("    name \"-\" is used), then the standard input stream");
        out.println("    is parsed.");
        out.println();
        out.println("- GUI mode");
        out.println();
        out.println("    Use the \"--gui\" (or \"-g\") option to start the");
        out.println("    Apache Tika GUI. You can drag and drop files from");
        out.println("    a normal file explorer to the GUI window to extract");
        out.println("    text content and metadata from the files.");
        out.println();
        out.println("- Server mode");
        out.println();
        out.println("    Use the \"-server\" (or \"-s\") option to start the");
        out.println("    Apache Tika server. The server will listen to the");
        out.println("    ports you specify as one or more arguments.");
        out.println();
    }

    private void displayMetModels() {
        Class<?>[] modelClasses = Metadata.class.getInterfaces();
        Arrays.sort(modelClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class<?> modelClass : modelClasses) {
            if (!modelClass.getSimpleName().contains("Tika")) continue;
            System.out.println(modelClass.getSimpleName());
            Field[] keyFields = modelClass.getFields();
            Arrays.sort(keyFields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Field keyField : keyFields) {
                System.out.println(" " + keyField.getName());
            }
        }
    }

    private void displayParsers(boolean includeMimeTypes) {
        this.displayParser(this.parser, includeMimeTypes, 0);
    }

    private void displayParser(Parser p, boolean includeMimeTypes, int i) {
        boolean isComposite = p instanceof CompositeParser;
        String name = p instanceof ParserDecorator ? ((ParserDecorator)p).getWrappedParser().getClass().getName() : p.getClass().getName();
        System.out.println(this.indent(i) + name + (isComposite ? " (Composite Parser):" : ""));
        if (includeMimeTypes && !isComposite) {
            for (MediaType mt : p.getSupportedTypes(this.context)) {
                System.out.println(this.indent(i + 2) + mt);
            }
        }
        if (isComposite) {
            Parser[] subParsers;
            for (Parser sp : subParsers = this.sortParsers(this.invertMediaTypeMap(((CompositeParser)p).getParsers()))) {
                this.displayParser(sp, includeMimeTypes, i + 2);
            }
        }
    }

    private String indent(int indent) {
        return "                     ".substring(0, indent);
    }

    private Parser[] sortParsers(Map<Parser, Set<MediaType>> parsers) {
        Parser[] sortedParsers = parsers.keySet().toArray(new Parser[parsers.size()]);
        Arrays.sort(sortedParsers, new Comparator<Parser>(){

            @Override
            public int compare(Parser p1, Parser p2) {
                String name1 = p1.getClass().getName();
                String name2 = p2.getClass().getName();
                return name1.compareTo(name2);
            }
        });
        return sortedParsers;
    }

    private Map<Parser, Set<MediaType>> invertMediaTypeMap(Map<MediaType, Parser> supported) {
        HashMap<Parser, Set<MediaType>> parsers = new HashMap<Parser, Set<MediaType>>();
        for (Map.Entry<MediaType, Parser> e : supported.entrySet()) {
            if (!parsers.containsKey(e.getValue())) {
                parsers.put(e.getValue(), new HashSet());
            }
            ((Set)parsers.get(e.getValue())).add(e.getKey());
        }
        return parsers;
    }

    private void displaySupportedTypes() {
        MediaTypeRegistry registry = this.parser.getMediaTypeRegistry();
        Map<MediaType, Parser> parsers = this.parser.getParsers();
        for (MediaType type : registry.getTypes()) {
            Parser parser;
            System.out.println(type);
            for (MediaType alias : registry.getAliases(type)) {
                System.out.println("  alias:     " + alias);
            }
            MediaType supertype = registry.getSupertype(type);
            if (supertype != null) {
                System.out.println("  supertype: " + supertype);
            }
            if ((parser = parsers.get(type)) == null) continue;
            System.out.println("  parser:    " + parser.getClass().getName());
        }
    }

    private static Writer getOutputWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            return new OutputStreamWriter(output, "UTF-8");
        }
        return new OutputStreamWriter(output);
    }

    private static TransformerHandler getTransformerHandler(OutputStream output, String method, String encoding) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", method);
        handler.getTransformer().setOutputProperty("indent", "yes");
        if (encoding != null) {
            handler.getTransformer().setOutputProperty("encoding", encoding);
        }
        handler.setResult(new StreamResult(output));
        return handler;
    }

    private class NoDocumentMetHandler
    extends DefaultHandler {
        private PrintWriter writer;
        private boolean metOutput;

        public NoDocumentMetHandler(PrintWriter writer) {
            this.writer = writer;
            this.metOutput = false;
        }

        public void endDocument() {
            Object[] names = TikaCLI.this.metadata.names();
            Arrays.sort(names);
            for (Object name : names) {
                this.writer.println((String)name + ": " + TikaCLI.this.metadata.get((String)name));
            }
            this.writer.flush();
            this.metOutput = true;
        }

        public boolean metOutput() {
            return this.metOutput;
        }
    }

    private class TikaServer
    extends Thread {
        private final ServerSocket server;

        public TikaServer(int port) throws IOException {
            super("Tika server at port " + port);
            this.server = new ServerSocket(port);
        }

        public void run() {
            try {
                try {
                    while (true) {
                        this.processSocketInBackground(this.server.accept());
                    }
                }
                catch (Throwable throwable) {
                    this.server.close();
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }

        private void processSocketInBackground(final Socket socket) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            OutputStream output = socket.getOutputStream();
                            TikaCLI.this.type.process(socket.getInputStream(), output);
                            output.flush();
                        }
                        finally {
                            socket.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static class FileEmbeddedDocumentExtractor
    implements EmbeddedDocumentExtractor {
        private int count = 0;
        private final TikaConfig config = TikaConfig.getDefaultConfig();

        private FileEmbeddedDocumentExtractor() {
        }

        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            File outputFile;
            String name = metadata.get("resourceName");
            if (name == null) {
                name = Integer.toString(this.count);
            }
            String contentType = metadata.get("Content-Type");
            if (name.indexOf(46) == -1 && contentType != null) {
                try {
                    name = name + this.config.getMimeRepository().forName(contentType).getExtension();
                }
                catch (MimeTypeException e) {
                    e.printStackTrace();
                }
            }
            if ((outputFile = new File(name)).exists()) {
                System.err.println("File '" + name + "' already exists; skipping");
                return;
            }
            System.out.println("Extracting '" + name + "' (" + contentType + ")");
            FileOutputStream os = new FileOutputStream(outputFile);
            IOUtils.copy(inputStream, (OutputStream)os);
            os.close();
            ++this.count;
        }
    }

    private class OutputType {
        private OutputType() {
        }

        public void process(InputStream input, OutputStream output) throws Exception {
            NoDocumentMetHandler metHandler;
            Parser p = TikaCLI.this.parser;
            if (TikaCLI.this.fork) {
                p = new ForkParser(TikaCLI.class.getClassLoader(), p);
            }
            ContentHandler handler = this.getContentHandler(output);
            p.parse(input, handler, TikaCLI.this.metadata, TikaCLI.this.context);
            if (handler instanceof NoDocumentMetHandler && !(metHandler = (NoDocumentMetHandler)handler).metOutput()) {
                metHandler.endDocument();
            }
        }

        protected ContentHandler getContentHandler(OutputStream output) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

