/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.RuntimeInterruptedException;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.SemaphoreOperationsCounter;
import com.hazelcast.monitor.LocalSemaphoreOperationStats;
import com.hazelcast.monitor.LocalSemaphoreStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SemaphoreProxyImpl
extends FactoryAwareNamedProxy
implements SemaphoreProxy {
    private transient SemaphoreProxy base = null;
    Data nameAsData = null;

    public SemaphoreProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new SemaphoreProxyReal();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (SemaphoreProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.substring("4:".length());
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.getName());
        }
        return this.nameAsData;
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "Semaphore [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemaphoreProxyImpl that = (SemaphoreProxyImpl)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    @Override
    public LocalSemaphoreStats getLocalSemaphoreStats() {
        this.ensure();
        return this.base.getLocalSemaphoreStats();
    }

    @Override
    public SemaphoreOperationsCounter getOperationsCounter() {
        this.ensure();
        return this.base.getOperationsCounter();
    }

    @Override
    public void acquire() throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        this.base.acquire();
    }

    @Override
    public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
        this.check(permits);
        this.ensure();
        this.base.acquire(permits);
    }

    @Override
    public Future acquireAsync() {
        return this.doAsyncAcquire(1, false);
    }

    @Override
    public Future acquireAsync(int permits) {
        this.check(permits);
        return this.doAsyncAcquire(permits, false);
    }

    @Override
    public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        this.base.acquireAttach();
    }

    @Override
    public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
        this.check(permits);
        this.ensure();
        this.base.acquireAttach(permits);
    }

    @Override
    public Future acquireAttachAsync() {
        return this.doAsyncAcquire(1, true);
    }

    @Override
    public Future acquireAttachAsync(int permits) {
        this.check(permits);
        return this.doAsyncAcquire(permits, true);
    }

    @Override
    public void attach() {
        this.ensure();
        this.base.attach();
    }

    @Override
    public void attach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.attach(permits);
    }

    @Override
    public int attachedPermits() {
        this.ensure();
        return this.base.attachedPermits();
    }

    @Override
    public int availablePermits() {
        this.ensure();
        return this.base.availablePermits();
    }

    @Override
    public void detach() {
        this.ensure();
        this.base.detach();
    }

    @Override
    public void detach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.detach(permits);
    }

    @Override
    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    @Override
    public int drainPermits() {
        this.ensure();
        return this.base.drainPermits();
    }

    @Override
    public void reducePermits(int permits) {
        this.check(permits);
        this.ensure();
        this.base.reducePermits(permits);
    }

    @Override
    public void release() {
        this.ensure();
        this.base.release();
    }

    @Override
    public void release(int permits) {
        this.check(permits);
        this.ensure();
        this.base.release(permits);
    }

    @Override
    public void releaseDetach() {
        this.ensure();
        this.base.releaseDetach();
    }

    @Override
    public void releaseDetach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.releaseDetach(permits);
    }

    @Override
    public boolean tryAcquire() {
        this.ensure();
        return this.base.tryAcquire();
    }

    @Override
    public boolean tryAcquire(int permits) {
        this.check(permits);
        this.ensure();
        return this.base.tryAcquire(permits);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        return this.base.tryAcquire(timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.check(permits, timeout, timeunit);
        this.ensure();
        return this.base.tryAcquire(permits, timeout, timeunit);
    }

    @Override
    public boolean tryAcquireAttach() {
        this.ensure();
        return this.base.tryAcquireAttach();
    }

    @Override
    public boolean tryAcquireAttach(int permits) {
        this.check(permits);
        this.ensure();
        return this.base.tryAcquireAttach(permits);
    }

    @Override
    public boolean tryAcquireAttach(long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        return this.base.tryAcquireAttach(timeout, timeunit);
    }

    @Override
    public boolean tryAcquireAttach(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.check(permits, timeout, timeunit);
        this.ensure();
        return this.base.tryAcquireAttach(permits, timeout, timeunit);
    }

    private void check(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Number of permits can not be negative: " + permits);
        }
    }

    private void check(int permits, long timeout, TimeUnit timeunit) {
        this.check(permits);
        if (timeout < -1L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeout);
        }
        if (timeunit == null) {
            throw new NullPointerException("TimeUnit can not be null.");
        }
    }

    private Future doAsyncAcquire(final Integer permits, final Boolean attach) {
        final SemaphoreProxyImpl semaphoreProxy = this;
        AsyncCall call = new AsyncCall(){

            @Override
            protected void call() {
                try {
                    if (attach.booleanValue()) {
                        semaphoreProxy.acquireAttach(permits);
                    } else {
                        semaphoreProxy.acquire(permits);
                    }
                    this.setResult(null);
                }
                catch (InterruptedException e) {
                    this.setResult(e);
                }
                catch (InstanceDestroyedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
                return msemaphore.cancelAcquire(SemaphoreProxyImpl.this.getNameAsData());
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    private class SemaphoreProxyReal
    implements SemaphoreProxy {
        SemaphoreOperationsCounter operationsCounter = new SemaphoreOperationsCounter();

        private SemaphoreProxyReal() {
        }

        @Override
        public Object getId() {
            return SemaphoreProxyImpl.this.name;
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.SEMAPHORE;
        }

        @Override
        public String getLongName() {
            return SemaphoreProxyImpl.this.name;
        }

        @Override
        public String getName() {
            return SemaphoreProxyImpl.this.name.substring("4:".length());
        }

        @Override
        public void destroy() {
            this.newMSemaphore().destroy(SemaphoreProxyImpl.this.getNameAsData());
            SemaphoreProxyImpl.this.factory.destroyInstanceClusterWide(SemaphoreProxyImpl.this.name, null);
        }

        @Override
        public void acquire() throws InstanceDestroyedException, InterruptedException {
            this.acquire(1);
        }

        @Override
        public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.doTryAcquire(permits, false, -1L);
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        @Override
        public Future acquireAsync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future acquireAsync(int permits) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
            this.acquireAttach(1);
        }

        @Override
        public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.doTryAcquire(permits, true, -1L);
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        @Override
        public Future acquireAttachAsync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future acquireAttachAsync(int permits) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void attach() {
            this.attach(1);
        }

        @Override
        public void attach(int permits) {
            this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), permits);
        }

        @Override
        public int attachedPermits() {
            return this.newMSemaphore().getAttached(SemaphoreProxyImpl.this.getNameAsData());
        }

        @Override
        public int availablePermits() {
            return this.newMSemaphore().getAvailable(SemaphoreProxyImpl.this.getNameAsData());
        }

        @Override
        public void detach() {
            this.detach(1);
        }

        @Override
        public void detach(int permits) {
            this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), -permits);
        }

        @Override
        public int drainPermits() {
            return this.newMSemaphore().drainPermits(SemaphoreProxyImpl.this.getNameAsData());
        }

        @Override
        public void release() {
            this.release(1);
        }

        @Override
        public void release(int permits) {
            this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, false);
        }

        @Override
        public void releaseDetach() {
            this.releaseDetach(1);
        }

        @Override
        public void releaseDetach(int permits) {
            this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, true);
        }

        @Override
        public boolean tryAcquire() {
            return this.tryAcquire(1);
        }

        @Override
        public boolean tryAcquire(int permits) {
            try {
                return this.doTryAcquire(permits, false, 0L);
            }
            catch (Throwable e) {
                return false;
            }
        }

        @Override
        public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            return this.tryAcquire(1, timeout, unit);
        }

        @Override
        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                return this.doTryAcquire(permits, false, unit.toMillis(timeout));
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        @Override
        public boolean tryAcquireAttach() {
            return this.tryAcquireAttach(1);
        }

        @Override
        public boolean tryAcquireAttach(int permits) {
            try {
                return this.doTryAcquire(permits, true, 0L);
            }
            catch (Throwable e) {
                return false;
            }
        }

        @Override
        public boolean tryAcquireAttach(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            return this.tryAcquireAttach(1, timeout, unit);
        }

        @Override
        public boolean tryAcquireAttach(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                return this.doTryAcquire(permits, true, unit.toMillis(timeout));
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        @Override
        public void reducePermits(int permits) {
            this.newMSemaphore().reduce(SemaphoreProxyImpl.this.getNameAsData(), permits);
        }

        @Override
        public LocalSemaphoreStats getLocalSemaphoreStats() {
            LocalSemaphoreStatsImpl localSemaphoreStats = new LocalSemaphoreStatsImpl();
            localSemaphoreStats.setOperationStats((LocalSemaphoreOperationStats)this.operationsCounter.getPublishedStats());
            return localSemaphoreStats;
        }

        @Override
        public SemaphoreOperationsCounter getOperationsCounter() {
            return this.operationsCounter;
        }

        private ConcurrentMapManager.MSemaphore newMSemaphore() {
            ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
            msemaphore.setOperationsCounter(this.operationsCounter);
            return msemaphore;
        }

        private boolean doTryAcquire(int permits, boolean attach, long timeout) throws InstanceDestroyedException {
            return this.newMSemaphore().tryAcquire(SemaphoreProxyImpl.this.getNameAsData(), permits, attach, timeout);
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

