/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import org.javasimon.callback.quantiles.BucketSample;

public final class Bucket {
    private final long min;
    private final long max;
    private int count;

    public Bucket(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public int getCount() {
        return this.count;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public boolean contains(long value) {
        return value >= this.min && value <= this.max;
    }

    public void incrementCount() {
        ++this.count;
    }

    public boolean addValue(long value) {
        if (this.contains(value)) {
            this.incrementCount();
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
    }

    public BucketSample sample() {
        return new BucketSample(this.min, this.max, this.count);
    }
}

