/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioParser
extends AbstractParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.audio("basic"), MediaType.audio("x-wav"), MediaType.audio("x-aiff"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        try {
            int bits;
            float rate;
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(stream);
            AudioFileFormat.Type type = fileFormat.getType();
            if (type == AudioFileFormat.Type.AIFC || type == AudioFileFormat.Type.AIFF) {
                metadata.set("Content-Type", "audio/x-aiff");
            } else if (type == AudioFileFormat.Type.AU || type == AudioFileFormat.Type.SND) {
                metadata.set("Content-Type", "audio/basic");
            } else if (type == AudioFileFormat.Type.WAVE) {
                metadata.set("Content-Type", "audio/x-wav");
            }
            AudioFormat audioFormat = fileFormat.getFormat();
            int channels = audioFormat.getChannels();
            if (channels != -1) {
                metadata.set("channels", String.valueOf(channels));
            }
            if ((rate = audioFormat.getSampleRate()) != -1.0f) {
                metadata.set("samplerate", String.valueOf(rate));
                metadata.set(XMPDM.AUDIO_SAMPLE_RATE, Integer.toString((int)rate));
            }
            if ((bits = audioFormat.getSampleSizeInBits()) != -1) {
                metadata.set("bits", String.valueOf(bits));
                if (bits == 8) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "8Int");
                } else if (bits == 16) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "16Int");
                } else if (bits == 32) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "32Int");
                }
            }
            metadata.set("encoding", audioFormat.getEncoding().toString());
            this.addMetadata(metadata, fileFormat.properties());
            this.addMetadata(metadata, audioFormat.properties());
        }
        catch (UnsupportedAudioFileException e) {
            // empty catch block
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    private void addMetadata(Metadata metadata, Map<String, Object> properties) {
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                metadata.set(entry.getKey(), value.toString());
            }
        }
    }
}

