/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.TextAutofit;
import org.apache.poi.xslf.usermodel.TextDirection;
import org.apache.poi.xslf.usermodel.VerticalAlignment;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFTextShape
extends XSLFSimpleShape {
    private final List<XSLFTextParagraph> _paragraphs = new ArrayList<XSLFTextParagraph>();

    XSLFTextShape(XmlObject shape, XSLFSheet sheet) {
        super(shape, sheet);
        CTTextBody txBody = this.getTextBody(false);
        if (txBody != null) {
            for (CTTextParagraph p : txBody.getPList()) {
                this._paragraphs.add(new XSLFTextParagraph(p, this));
            }
        }
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextParagraph p : this._paragraphs) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append(p.getText());
        }
        return out.toString();
    }

    public List<XSLFTextParagraph> getTextParagraphs() {
        return this._paragraphs;
    }

    public XSLFTextParagraph addNewTextParagraph() {
        CTTextBody txBody = this.getTextBody(true);
        CTTextParagraph p = txBody.addNewP();
        XSLFTextParagraph paragraph = new XSLFTextParagraph(p, this);
        this._paragraphs.add(paragraph);
        return paragraph;
    }

    public void setFillColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetSolidFill()) {
                spPr.unsetSolidFill();
            }
        } else {
            CTSolidColorFillProperties fill = spPr.isSetSolidFill() ? spPr.getSolidFill() : spPr.addNewSolidFill();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            fill.setSrgbClr(rgb);
        }
    }

    public Color getFillColor() {
        CTShapeProperties spPr = this.getSpPr();
        if (!spPr.isSetSolidFill()) {
            return null;
        }
        CTSolidColorFillProperties fill = spPr.getSolidFill();
        if (!fill.isSetSrgbClr()) {
            return null;
        }
        byte[] val = fill.getSrgbClr().getVal();
        return new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
    }

    public void setVerticalAlignment(VerticalAlignment anchor) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (anchor == null) {
                if (bodyPr.isSetAnchor()) {
                    bodyPr.unsetAnchor();
                }
            } else {
                bodyPr.setAnchor(STTextAnchoringType.Enum.forInt(anchor.ordinal() + 1));
            }
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        STTextAnchoringType.Enum val;
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null && (val = bodyPr.getAnchor()) != null) {
            return VerticalAlignment.values()[val.intValue() - 1];
        }
        return VerticalAlignment.TOP;
    }

    public void setTextDirection(TextDirection orientation) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (orientation == null) {
                if (bodyPr.isSetVert()) {
                    bodyPr.unsetVert();
                }
            } else {
                bodyPr.setVert(STTextVerticalType.Enum.forInt(orientation.ordinal() + 1));
            }
        }
    }

    public TextDirection getTextDirection() {
        STTextVerticalType.Enum val;
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null && (val = bodyPr.getVert()) != null) {
            return TextDirection.values()[val.intValue() - 1];
        }
        return TextDirection.HORIZONTAL;
    }

    public double getMarginBottom() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            return bodyPr.isSetBIns() ? Units.toPoints(bodyPr.getBIns()) : -1.0;
        }
        return -1.0;
    }

    public double getMarginLeft() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            return bodyPr.isSetLIns() ? Units.toPoints(bodyPr.getLIns()) : -1.0;
        }
        return -1.0;
    }

    public double getMarginRight() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            return bodyPr.isSetRIns() ? Units.toPoints(bodyPr.getRIns()) : -1.0;
        }
        return -1.0;
    }

    public double getMarginTop() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            return bodyPr.isSetTIns() ? Units.toPoints(bodyPr.getTIns()) : -1.0;
        }
        return -1.0;
    }

    public void setMarginBottom(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetBIns();
            } else {
                bodyPr.setBIns(Units.toEMU(margin));
            }
        }
    }

    public void setMarginLeft(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetLIns();
            } else {
                bodyPr.setLIns(Units.toEMU(margin));
            }
        }
    }

    public void setMarginRight(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetRIns();
            } else {
                bodyPr.setRIns(Units.toEMU(margin));
            }
        }
    }

    public void setMarginTop(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetTIns();
            } else {
                bodyPr.setTIns(Units.toEMU(margin));
            }
        }
    }

    public boolean getWordWrap() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            return bodyPr.getWrap() == STTextWrappingType.SQUARE;
        }
        return false;
    }

    public void setWordWrap(boolean wrap) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            bodyPr.setWrap(wrap ? STTextWrappingType.SQUARE : STTextWrappingType.NONE);
        }
    }

    public void setTextAutofit(TextAutofit value) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (bodyPr.isSetSpAutoFit()) {
                bodyPr.unsetSpAutoFit();
            }
            if (bodyPr.isSetNoAutofit()) {
                bodyPr.unsetNoAutofit();
            }
            if (bodyPr.isSetNormAutofit()) {
                bodyPr.unsetNormAutofit();
            }
            switch (value) {
                case NONE: {
                    bodyPr.addNewNoAutofit();
                    break;
                }
                case NORMAL: {
                    bodyPr.addNewNormAutofit();
                    break;
                }
                case SHAPE: {
                    bodyPr.addNewSpAutoFit();
                }
            }
        }
    }

    public TextAutofit getTextAutofit() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (bodyPr.isSetNoAutofit()) {
                return TextAutofit.NONE;
            }
            if (bodyPr.isSetNormAutofit()) {
                return TextAutofit.NORMAL;
            }
            if (bodyPr.isSetSpAutoFit()) {
                return TextAutofit.SHAPE;
            }
        }
        return TextAutofit.NORMAL;
    }

    protected CTTextBodyProperties getTextBodyPr() {
        CTTextBody textBody = this.getTextBody(false);
        return textBody == null ? null : textBody.getBodyPr();
    }

    protected abstract CTTextBody getTextBody(boolean var1);
}

