/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class RevisionMarkAuthorTable {
    private short fExtend = (short)-1;
    private short cData = 0;
    private short cbExtra = 0;
    private String[] entries;

    public RevisionMarkAuthorTable(byte[] tableStream, int offset, int size) throws IOException {
        this.fExtend = LittleEndian.getShort(tableStream, offset);
        if (this.fExtend != 65535) {
            // empty if block
        }
        this.cData = LittleEndian.getShort(tableStream, offset += 2);
        this.cbExtra = LittleEndian.getShort(tableStream, offset += 2);
        if (this.cbExtra != 0) {
            // empty if block
        }
        offset += 2;
        this.entries = new String[this.cData];
        for (int i = 0; i < this.cData; ++i) {
            short len = LittleEndian.getShort(tableStream, offset);
            String name = StringUtil.getFromUnicodeLE(tableStream, offset += 2, len);
            offset += len * 2;
            this.entries[i] = name;
        }
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public String getAuthor(int index) {
        String auth = null;
        if (index >= 0 && index < this.entries.length) {
            auth = this.entries[index];
        }
        return auth;
    }

    public int getSize() {
        return this.cData;
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        byte[] header = new byte[6];
        LittleEndian.putShort(header, 0, this.fExtend);
        LittleEndian.putShort(header, 2, this.cData);
        LittleEndian.putShort(header, 4, this.cbExtra);
        tableStream.write(header);
        for (String name : this.entries) {
            byte[] buf = new byte[name.length() * 2 + 2];
            LittleEndian.putShort(buf, 0, (short)name.length());
            StringUtil.putUnicodeLE(name, buf, 2);
            tableStream.write(buf);
        }
    }
}

