
Name:          open-xchange-grizzly
BuildArch:     noarch
#!BuildIgnore: post-build-checks
BuildRequires: ant
BuildRequires: ant-nodeps
BuildRequires: open-xchange-core
BuildRequires: java-devel >= 1.6.0
Version:       7.0.1
%define        ox_release 8
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       The Open-Xchange HTTP Server and Servlet Container
Requires:      open-xchange-core >= 7.0.1
Provides:      open-xchange-httpservice
Conflicts:     open-xchange-ajp

%description
This package implements an HTTP Server and provides the OSGi HTTP service.


Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
if [ ${1:-0} -eq 2 ]; then
    # only when updating
    . /opt/open-xchange/lib/oxfunctions.sh

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SoftwareChange_Request-1293
    pfile=/opt/open-xchange/etc/grizzly.properties
    if ! ox_exists_property com.openexchange.http.grizzly.hasAJPEnabled $pfile; then
       ox_set_property com.openexchange.http.grizzly.hasAJPEnabled "false" $pfile
    fi
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%dir /opt/open-xchange/etc/
%config(noreplace) /opt/open-xchange/etc/*

%changelog
* Wed May 22 2013 Marc Arens <marc.arens@open-xchange.com>
Build for patch 2013-05-22
* Mon May 13 2013 Marc Arens <marc.arens@open-xchange.com>
Build for patch 2013-05-09
* Tue Apr 02 2013 Marc Arens <marc.arens@open-xchange.com>
Build for patch 2013-04-04
* Mon Mar 04 2013 Marc Arens <marc.arens@open-xchange.com>
Build for patch 2013-03-07
* Tue Feb 19 2013 Marc Arens <marc.arens@open-xchange.com>
Fourth release candidate for 7.0.1
* Tue Feb 19 2013 Marc Arens <marc.arens@open-xchange.com>
Third release candidate for 7.0.1
* Thu Feb 14 2013 Marc Arens <marc.arens@open-xchange.com>
Second release candidate for 7.0.1
* Fri Feb 01 2013 Marc Arens <marc.arens@open-xchange.com>
First release candidate for 7.0.1
* Thu Jan 10 2013 Marc Arens <marc.arens@open-xchange.com>
prepare for 7.0.1
* Tue Dec 04 2012 Marc Arens <marc.arens@open-xchange.com>
First release candidate for 7.0.0
* Tue Dec 04 2012 Marc Arens <marc.arens@open-xchange.com>
prepare for 7.0.0 release
* Tue Nov 13 2012 Marc Arens <marc.arens@open-xchange.com>
First release candidate for EDP drop #6
* Tue Nov 06 2012 Marc Arens <marc.arens@open-xchange.com>
Fourth release candidate for 6.22.1
* Fri Nov 02 2012 Marc Arens <marc.arens@open-xchange.com>
Third release candidate for 6.22.1
* Wed Oct 31 2012 Marc Arens <marc.arens@open-xchange.com>
Second release candidate for 6.22.1
* Fri Oct 26 2012 Marc Arens <marc.arens@open-xchange.com>
Third release build for EDP drop #5
* Fri Oct 26 2012 Marc Arens <marc.arens@open-xchange.com>
First release candidate for 6.22.1
* Fri Oct 26 2012 Marc Arens <marc.arens@open-xchange.com>
Second release build for EDP drop #5
* Fri Oct 26 2012 Marc Arens <marc.arens@open-xchange.com>
prepare for 6.22.1
* Fri Oct 26 2012 Marc Arens <marc.arens@open-xchange.com>
prepare for 6.22.1
* Thu Oct 11 2012 Marc Arens <marc.arens@open-xchange.com>
Release build for EDP drop #5
* Tue Sep 04 2012 Marc Arens <marc.arens@open-xchange.com>
First release candidate for 6.23.0
* Mon Sep 03 2012 Marc Arens <marc.arens@open-xchange.com>
prepare for next EDP drop
* Tue Jul 03 2012 Marc Arens <marc.arens@open-xchange.com>
Release build for EDP drop #2
* Wed Jun 20 2012 Marc Arens <marc.arens@open-xchange.com>
Initial release
