/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.Chunk;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.utils.Charsets;

public class BufferChunk
implements Chunk {
    private Buffer buffer;
    private int start;
    private int end;
    private int limit;
    String cachedString;
    Charset cachedStringCharset;

    public void setBufferChunk(Buffer buffer, int start, int end) {
        this.setBufferChunk(buffer, start, end, end);
    }

    public void setBufferChunk(Buffer buffer, int start, int end, int limit) {
        this.buffer = buffer;
        this.start = start;
        this.end = end;
        this.limit = limit;
        this.resetStringCache();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.resetStringCache();
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.resetStringCache();
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
        this.resetStringCache();
    }

    @Override
    public final int getLength() {
        return this.end - this.start;
    }

    public final boolean isNull() {
        return this.buffer == null;
    }

    public void allocate(int size) {
        if (this.isNull() || this.limit - this.start < size) {
            this.setBufferChunk(Buffers.wrap(null, (byte[])new byte[size]), 0, 0, size);
        }
        this.end = this.start;
    }

    @Override
    public void delete(int start, int end) {
        int absDeleteStart = this.start + start;
        int absDeleteEnd = this.start + end;
        int diff = this.end - absDeleteEnd;
        if (diff == 0) {
            this.end = absDeleteStart;
        } else {
            int oldPos = this.buffer.position();
            int oldLim = this.buffer.limit();
            try {
                Buffers.setPositionLimit((Buffer)this.buffer, (int)absDeleteStart, (int)(absDeleteStart + diff));
                this.buffer.put(this.buffer, absDeleteEnd, diff);
                this.end = absDeleteStart + diff;
            }
            finally {
                Buffers.setPositionLimit((Buffer)this.buffer, (int)oldPos, (int)oldLim);
            }
        }
        this.resetStringCache();
    }

    public void append(BufferChunk bc) {
        int oldPos = this.buffer.position();
        int oldLim = this.buffer.limit();
        int srcLen = bc.getLength();
        Buffers.setPositionLimit((Buffer)this.buffer, (int)this.end, (int)(this.end + srcLen));
        this.buffer.put(bc.getBuffer(), bc.getStart(), srcLen);
        Buffers.setPositionLimit((Buffer)this.buffer, (int)oldPos, (int)oldLim);
        this.end += srcLen;
    }

    @Override
    public final int indexOf(char c, int fromIndex) {
        int idx = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, c);
        return idx >= this.start ? idx - this.start : -1;
    }

    @Override
    public final int indexOf(String s, int fromIndex) {
        int idx = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, s);
        return idx >= this.start ? idx - this.start : -1;
    }

    boolean startsWith(String s, int pos) {
        int len = s.length();
        if (len > this.getLength() - pos) {
            return false;
        }
        int off = this.start + pos;
        int i = 0;
        while (i < len) {
            if (this.buffer.get(off++) != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        int len = s.length();
        if (len > this.getLength() - pos) {
            return false;
        }
        int off = this.start + pos;
        int i = 0;
        while (i < len) {
            if (Ascii.toLower(this.buffer.get(off++)) != Ascii.toLower(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int findBytesAscii(byte[] b) {
        byte first = b[0];
        int from = this.getStart();
        int to = this.getEnd();
        int srcEnd = b.length;
        int i = from;
        while (i <= to - srcEnd) {
            if (Ascii.toLower(this.buffer.get(i)) == first) {
                int myPos = i + 1;
                int srcPos = 1;
                while (srcPos < srcEnd) {
                    if (Ascii.toLower(this.buffer.get(myPos++)) != b[srcPos++]) break;
                    if (srcPos != srcEnd) continue;
                    return i - from;
                }
            }
            ++i;
        }
        return -1;
    }

    public int hash() {
        int code = 0;
        int i = this.start;
        while (i < this.end) {
            code = code * 31 + this.buffer.get(i);
            ++i;
        }
        return code;
    }

    public boolean equals(CharSequence s) {
        if (this.getLength() != s.length()) {
            return false;
        }
        int i = this.start;
        while (i < this.end) {
            if (this.buffer.get(i) != s.charAt(i - this.start)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(CharSequence s) {
        if (this.getLength() != s.length()) {
            return false;
        }
        int i = this.start;
        while (i < this.end) {
            if (Ascii.toLower(this.buffer.get(i)) != Ascii.toLower(s.charAt(i - this.start))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] b) {
        if (this.getLength() != b.length) {
            return false;
        }
        int i = this.start;
        while (i < this.end) {
            if (Ascii.toLower(this.buffer.get(i)) != Ascii.toLower(b[i - this.start])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCaseLowerCase(byte[] b) {
        return BufferChunk.equalsIgnoreCaseLowerCase(this.buffer, this.start, this.end, b);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        if (charset == null) {
            charset = Charsets.UTF8_CHARSET;
        }
        if (this.cachedString != null && charset.equals(this.cachedStringCharset)) {
            return this.cachedString;
        }
        this.cachedString = this.buffer.toStringContent(charset, this.start, this.end);
        this.cachedStringCharset = charset;
        return this.cachedString;
    }

    @Override
    public String toString(int start, int end) {
        return this.buffer.toStringContent(Charsets.UTF8_CHARSET, this.start + start, this.start + end);
    }

    protected final void resetStringCache() {
        this.cachedString = null;
        this.cachedStringCharset = null;
    }

    protected final void reset() {
        this.buffer = null;
        this.start = -1;
        this.end = -1;
        this.limit = -1;
        this.resetStringCache();
    }

    public final void recycle() {
        this.reset();
    }

    protected void notifyDirectUpdate() {
    }

    public static int indexOf(Buffer buffer, int off, int end, char qq) {
        while (off < end) {
            byte b = buffer.get(off);
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int indexOf(Buffer buffer, int off, int end, CharSequence s) {
        int strLen = s.length();
        if (strLen == 0) {
            return off;
        }
        if (strLen > end - off) {
            return -1;
        }
        int strOffs = 0;
        int lastOffs = end - strLen;
        while (off <= lastOffs + strOffs) {
            byte b = buffer.get(off);
            if (b == s.charAt(strOffs)) {
                if (++strOffs == strLen) {
                    return off - strLen + 1;
                }
            } else {
                strOffs = 0;
            }
            ++off;
        }
        return -1;
    }

    public int compareIgnoreCase(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        int i = 0;
        while (i < len && result == 0) {
            if (Ascii.toLower(this.buffer.get(i + start)) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
            } else if (Ascii.toLower(this.buffer.get(i + start)) < Ascii.toLower(compareTo.charAt(i))) {
                result = -1;
            }
            ++i;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public int compare(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        int i = 0;
        while (i < len && result == 0) {
            if (this.buffer.get(i + start) > compareTo.charAt(i)) {
                result = 1;
            } else if (this.buffer.get(i + start) < compareTo.charAt(i)) {
                result = -1;
            }
            ++i;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public static boolean equalsIgnoreCaseLowerCase(Buffer buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len != cmpTo.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (Ascii.toLower(buffer.get(i + start)) != cmpTo[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(Buffer buffer, int start, int end, byte[] cmpTo) {
        int len = end - start;
        if (len < cmpTo.length) {
            return false;
        }
        int i = 0;
        while (i < cmpTo.length) {
            if (buffer.get(start + i) != cmpTo[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

