/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.io.TemporaryHeapBuffer;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Exceptions;

public class OutputBuffer {
    private static final Logger LOGGER = Grizzly.logger(OutputBuffer.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_CHAR_BUFFER_SIZE = 65537;
    private HttpResponsePacket response;
    private FilterChainContext ctx;
    private CompositeBuffer compositeBuffer;
    private Buffer currentBuffer;
    private final TemporaryHeapBuffer temporaryWriteBuffer = new TemporaryHeapBuffer();
    private final ByteArrayCloner cloner = new ByteArrayCloner();
    private final List<LifeCycleListener> lifeCycleListeners = new ArrayList<LifeCycleListener>(2);
    private boolean committed;
    private boolean finished;
    private boolean closed;
    private CharsetEncoder encoder;
    private final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private char[] charsArray;
    private int charsArrayLength;
    private CharBuffer charsBuffer;
    private MemoryManager memoryManager;
    private WriteHandler handler;
    private final AtomicReference<Throwable> asyncError = new AtomicReference();
    private WriteHandler asyncWriteQueueHandler;
    private AsyncQueueWriter asyncWriter;
    private boolean fileTransferRequested;
    private int bufferSize = 8192;
    private boolean asyncEnabled = true;
    private boolean sendfileEnabled;
    private Response serverResponse;
    private final CompletionHandler<WriteResult> onAsyncErrorCompletionHandler = new OnErrorCompletionHandler();
    private final CompletionHandler<WriteResult> onWritePossibleCompletionHandler = new OnWritePossibleCompletionHandler();

    public void initialize(Response response, FilterChainContext ctx) {
        this.serverResponse = response;
        this.response = response.getResponse();
        this.sendfileEnabled = response.isSendFileEnabled();
        this.ctx = ctx;
        this.memoryManager = ctx.getMemoryManager();
        Connection c = ctx.getConnection();
        this.asyncWriter = (AsyncQueueWriter)c.getTransport().getWriter(c);
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }

    public void prepareCharacterEncoder() {
        this.getEncoder();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void registerLifeCycleListener(LifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public boolean removeLifeCycleListener(LifeCycleListener listener) {
        return this.lifeCycleListeners.remove(listener);
    }

    public void setBufferSize(int bufferSize) {
        if (!this.committed && this.currentBuffer == null) {
            this.bufferSize = bufferSize;
        }
        if (this.charsArray != null && this.charsArray.length < bufferSize) {
            char[] newCharsArray = new char[bufferSize];
            System.arraycopy(this.charsArray, 0, newCharsArray, 0, this.charsArrayLength);
            this.charsBuffer = CharBuffer.wrap(newCharsArray);
            this.charsArray = newCharsArray;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.compositeBuffer = null;
        if (this.currentBuffer != null) {
            this.currentBuffer.clear();
        }
        this.charsArrayLength = 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getBufferedDataSize() {
        int size = 0;
        if (this.compositeBuffer != null) {
            size += this.compositeBuffer.remaining();
        }
        if (this.currentBuffer != null) {
            size += this.currentBuffer.position();
        }
        return size += this.charsArrayLength << 1;
    }

    public void recycle() {
        this.response = null;
        if (this.compositeBuffer != null) {
            this.compositeBuffer.dispose();
            this.compositeBuffer = null;
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.dispose();
            this.currentBuffer = null;
        }
        this.temporaryWriteBuffer.recycle();
        if (this.charsArray != null) {
            this.charsArrayLength = 0;
            if (this.charsArray.length < 65537) {
                this.charsBuffer.clear();
            } else {
                this.charsBuffer = null;
                this.charsArray = null;
            }
        }
        this.fileTransferRequested = false;
        this.encoder = null;
        this.ctx = null;
        this.memoryManager = null;
        this.handler = null;
        this.asyncError.set(null);
        this.asyncWriteQueueHandler = null;
        this.asyncWriter = null;
        this.committed = false;
        this.finished = false;
        this.closed = false;
        this.lifeCycleListeners.clear();
    }

    public void endRequest() throws IOException {
        this.handleAsyncErrors();
        if (this.finished) {
            return;
        }
        WriteHandler asyncWriteQueueHandlerLocal = this.asyncWriteQueueHandler;
        if (asyncWriteQueueHandlerLocal != null) {
            this.asyncWriteQueueHandler = null;
            Connection c = this.ctx.getConnection();
            TaskQueue tqueue = ((NIOConnection)c).getAsyncWriteQueue();
            tqueue.forgetWritePossible(asyncWriteQueueHandlerLocal);
        }
        if (!this.closed) {
            this.close();
        }
        if (this.ctx != null) {
            this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        }
        this.finished = true;
    }

    public void acknowledge() throws IOException {
        this.ctx.write((Object)this.response, !this.asyncEnabled);
    }

    public void writeChar(int c) throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.checkCharBuffer();
        if (this.charsArrayLength == this.charsArray.length) {
            this.flushCharsToBuf(true);
        }
        this.charsArray[this.charsArrayLength++] = (char)c;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.checkCharBuffer();
        int remaining = this.charsArray.length - this.charsArrayLength;
        if (len <= remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, len);
            this.charsArrayLength += len;
        } else if (len - remaining < remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, remaining);
            this.charsArrayLength += remaining;
            this.flushCharsToBuf(true);
            System.arraycopy(cbuf, off + remaining, this.charsArray, 0, len - remaining);
            this.charsArrayLength = len - remaining;
        } else {
            this.flushCharsToBuf(false);
            this.flushCharsToBuf(CharBuffer.wrap(cbuf, off, len), true);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        int offLocal = off;
        int lenLocal = len;
        this.checkCharBuffer();
        do {
            int remaining = this.charsArray.length - this.charsArrayLength;
            int workingLen = Math.min(lenLocal, remaining);
            str.getChars(offLocal, offLocal + workingLen, this.charsArray, this.charsArrayLength);
            this.charsArrayLength += workingLen;
            offLocal += workingLen;
            if ((lenLocal -= workingLen) <= 0) continue;
            this.flushCharsToBuf(false);
        } while (lenLocal > 0);
        this.flushBinaryBuffersIfNeeded();
    }

    public void writeByte(int b) throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.checkCurrentBuffer();
        if (this.currentBuffer.hasRemaining()) {
            this.currentBuffer.put((byte)b);
        } else {
            this.finishCurrentBuffer();
            this.checkCurrentBuffer();
            this.currentBuffer.put((byte)b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void sendfile(File file, CompletionHandler<WriteResult> handler) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null");
        }
        this.sendfile(file, 0L, file.length(), handler);
    }

    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) throws IOException {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        if (this.fileTransferRequested) {
            throw new IllegalStateException("Only one file transfer allowed per request");
        }
        this.reset();
        FileTransfer f = new FileTransfer(file, offset, length);
        this.fileTransferRequested = true;
        this.response.setContentLengthLong((long)f.remaining());
        if (this.response.getContentType() == null) {
            this.response.setContentType(MimeType.getByFilename(file.getName()));
        }
        this.response.setHeader(Header.ContentEncoding, "identity");
        this.flush();
        boolean suspendedAtStart = this.serverResponse.isSuspended();
        CompletionHandler<WriteResult> ch = suspendedAtStart && handler != null ? handler : (!suspendedAtStart && handler != null ? this.suspendAndCreateHandler(handler) : this.createInternalCompletionHandler(file, suspendedAtStart));
        this.ctx.write((Object)f, ch);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        if (this.bufferSize >= len && (this.currentBuffer == null || this.currentBuffer.remaining() >= len)) {
            this.checkCurrentBuffer();
            assert (this.currentBuffer != null);
            this.currentBuffer.put(b, off, len);
        } else {
            this.temporaryWriteBuffer.reset(b, off, len);
            this.finishCurrentBuffer();
            this.doCommit();
            if (this.compositeBuffer != null) {
                this.compositeBuffer.append((Object)this.temporaryWriteBuffer);
                this.writeContentBuffer0((Buffer)this.compositeBuffer, false, this.cloner);
                this.compositeBuffer = null;
            } else {
                this.writeContentBuffer0((Buffer)this.temporaryWriteBuffer, false, this.cloner);
            }
        }
    }

    public void close() throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(true) && (isJustCommitted || this.response.isChunked())) {
            this.forceCommitHeaders(true);
        }
    }

    public void flush() throws IOException {
        this.handleAsyncErrors();
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(false) && isJustCommitted) {
            this.forceCommitHeaders(false);
        }
    }

    public void writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Buffer w = Buffers.wrap((MemoryManager)this.memoryManager, (ByteBuffer)byteBuffer);
        w.allowBufferDispose(false);
        this.writeBuffer(w);
    }

    public void writeBuffer(Buffer buffer) throws IOException {
        this.handleAsyncErrors();
        this.finishCurrentBuffer();
        this.checkCompositeBuffer();
        this.compositeBuffer.append((Object)buffer);
        if (this.compositeBuffer.remaining() > this.bufferSize) {
            this.flush();
        }
    }

    public boolean canWriteChar(int length) {
        if (length <= 0 || this.getMaxAsyncWriteQueueSize() <= 0) {
            return true;
        }
        CharsetEncoder e = this.getEncoder();
        int len = Float.valueOf((float)length * e.averageBytesPerChar()).intValue();
        return this.canWrite(len);
    }

    public boolean canWrite(int length) {
        if (length <= 0 || this.getMaxAsyncWriteQueueSize() <= 0) {
            return true;
        }
        Connection c = this.ctx.getConnection();
        return this.asyncWriter.canWrite(c, length + this.getBufferedDataSize());
    }

    public void notifyCanWrite(WriteHandler handler, int length) {
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to set a new handler before the existing handler has been notified.");
        }
        Throwable asyncException = this.asyncError.get();
        if (asyncException != null) {
            handler.onError((Throwable)Exceptions.makeIOException((Throwable)asyncException));
            return;
        }
        this.handler = handler;
        int maxBytes = this.getMaxAsyncWriteQueueSize();
        if (maxBytes > 0 && length > maxBytes) {
            throw new IllegalArgumentException("Illegal request to write " + length + " bytes.  Max allowable write is " + maxBytes + '.');
        }
        final Connection c = this.ctx.getConnection();
        int totalLength = length + this.getBufferedDataSize();
        if (this.canWrite(totalLength)) {
            AsyncQueueWriter.Reentrant reentrant = this.asyncWriter.getWriteReentrant();
            if (!this.asyncWriter.isMaxReentrantsReached(reentrant)) {
                this.notifyWritePossible();
            } else {
                this.notifyWritePossibleAsync(c);
            }
            return;
        }
        TaskQueue taskQueue = ((NIOConnection)c).getAsyncWriteQueue();
        this.asyncWriteQueueHandler = new WriteHandler(){

            public void onWritePossible() throws Exception {
                AsyncQueueWriter.Reentrant reentrant = OutputBuffer.this.asyncWriter.getWriteReentrant();
                if (!OutputBuffer.this.asyncWriter.isMaxReentrantsReached(reentrant)) {
                    OutputBuffer.this.notifyWritePossible();
                } else {
                    OutputBuffer.this.notifyWritePossibleAsync(c);
                }
            }

            public void onError(Throwable t) {
            }
        };
        try {
            taskQueue.notifyWritePossible(this.asyncWriteQueueHandler, totalLength);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getMaxAsyncWriteQueueSize() {
        return this.ctx.getConnection().getMaxAsyncWriteQueueSize();
    }

    private void notifyWritePossibleAsync(Connection c) {
        this.asyncWriter.write(c, (WritableMessage)Buffers.EMPTY_BUFFER, this.onWritePossibleCompletionHandler);
    }

    private void notifyWritePossible() {
        AsyncQueueWriter.Reentrant reentrant = this.asyncWriter.getWriteReentrant();
        WriteHandler localHandler = this.handler;
        if (localHandler != null) {
            try {
                try {
                    this.handler = null;
                    reentrant.incAndGet();
                    localHandler.onWritePossible();
                }
                catch (Exception ioe) {
                    localHandler.onError((Throwable)ioe);
                    reentrant.decAndGet();
                }
            }
            finally {
                reentrant.decAndGet();
            }
        }
    }

    private void handleAsyncErrors() throws IOException {
        Throwable t = this.asyncError.get();
        if (t != null) {
            throw Exceptions.makeIOException((Throwable)t);
        }
    }

    private boolean flushAllBuffers(boolean isLast) throws IOException {
        if (this.charsArrayLength > 0) {
            this.flushCharsToBuf(false);
        }
        return this.flushBinaryBuffers(isLast);
    }

    private boolean flushBinaryBuffers(boolean isLast) throws IOException {
        CompositeBuffer bufferToFlush;
        boolean isFlushComposite;
        if (!this.response.isChunkingAllowed() && this.response.getContentLength() == -1L) {
            if (!isLast) {
                return false;
            }
            this.response.setContentLength(this.getBufferedDataSize());
        }
        boolean bl = isFlushComposite = this.compositeBuffer != null && this.compositeBuffer.hasRemaining();
        if (isFlushComposite) {
            this.finishCurrentBuffer();
            bufferToFlush = this.compositeBuffer;
            this.compositeBuffer = null;
        } else if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            bufferToFlush = this.currentBuffer;
            this.currentBuffer = null;
        } else {
            bufferToFlush = null;
        }
        if (bufferToFlush != null) {
            this.writeContentBuffer0((Buffer)bufferToFlush, isLast, null);
            return true;
        }
        return false;
    }

    private void writeContentBuffer0(Buffer bufferToFlush, boolean isLast, MessageCloner<Buffer> messageCloner) throws IOException {
        HttpContent.Builder builder = this.response.httpContentBuilder();
        builder.content(bufferToFlush).last(isLast);
        this.ctx.write(null, (Object)builder.build(), this.onAsyncErrorCompletionHandler, null, messageCloner, !this.asyncEnabled);
    }

    private void checkCharBuffer() {
        if (this.charsArray == null) {
            this.charsArray = new char[this.bufferSize];
            this.charsBuffer = CharBuffer.wrap(this.charsArray);
        }
    }

    private void checkCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.memoryManager.allocate(this.bufferSize);
            this.currentBuffer.allowBufferDispose(true);
        }
    }

    private void finishCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            this.checkCompositeBuffer();
            this.compositeBuffer.append((Object)this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    private CharsetEncoder getEncoder() {
        if (this.encoder == null) {
            String encoding = this.response.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            this.encoder = this.encoders.get(encoding);
            if (this.encoder == null) {
                Charset cs = Charsets.lookupCharset((String)encoding);
                this.encoder = cs.newEncoder();
                this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.encoders.put(encoding, this.encoder);
            } else {
                this.encoder.reset();
            }
        }
        return this.encoder;
    }

    private boolean doCommit() throws IOException {
        if (!this.committed) {
            this.notifyCommit();
            this.committed = true;
            return true;
        }
        return false;
    }

    private void forceCommitHeaders(boolean isLast) throws IOException {
        if (isLast) {
            if (this.response != null) {
                HttpContent.Builder builder = this.response.httpContentBuilder();
                builder.last(true);
                this.ctx.write((Object)builder.build(), !this.asyncEnabled);
            }
        } else {
            this.ctx.write((Object)this.response, !this.asyncEnabled);
        }
    }

    private void checkCompositeBuffer() {
        if (this.compositeBuffer == null) {
            CompositeBuffer buffer = CompositeBuffer.newBuffer((MemoryManager)this.memoryManager);
            buffer.allowBufferDispose(true);
            buffer.allowInternalBuffersDispose(true);
            this.compositeBuffer = buffer;
        }
    }

    private void flushCharsToBuf(boolean canFlushToNet) throws IOException {
        this.charsBuffer.limit(this.charsArrayLength);
        try {
            this.flushCharsToBuf(this.charsBuffer, canFlushToNet);
        }
        finally {
            this.charsArrayLength = 0;
            this.charsBuffer.clear();
        }
    }

    private void flushCharsToBuf(CharBuffer charBuf, boolean canFlushToNet) throws IOException {
        CoderResult res;
        boolean isOverflow;
        if (!charBuf.hasRemaining()) {
            return;
        }
        CharsetEncoder enc = this.getEncoder();
        do {
            this.checkCurrentBuffer();
            ByteBuffer currentByteBuffer = this.currentBuffer.toByteBuffer();
            int bufferPos = this.currentBuffer.position();
            int byteBufferPos = currentByteBuffer.position();
            res = enc.encode(charBuf, currentByteBuffer, true);
            this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
            boolean bl = isOverflow = res == CoderResult.OVERFLOW;
            if (!isOverflow) continue;
            this.finishCurrentBuffer();
        } while (isOverflow);
        if (res != CoderResult.UNDERFLOW) {
            throw new IOException("Encoding error");
        }
        if (canFlushToNet) {
            this.flushBinaryBuffersIfNeeded();
        }
    }

    private void flushBinaryBuffersIfNeeded() throws IOException {
        if (this.compositeBuffer != null) {
            this.doCommit();
            this.flushBinaryBuffers(false);
        }
    }

    private void notifyCommit() throws IOException {
        int i = 0;
        int len = this.lifeCycleListeners.size();
        while (i < len) {
            this.lifeCycleListeners.get(i).onCommit();
            ++i;
        }
    }

    private CompletionHandler<WriteResult> createInternalCompletionHandler(final File file, boolean suspendedAtStart) {
        if (!suspendedAtStart) {
            this.serverResponse.suspend();
        }
        CompletionHandler<WriteResult> ch = new CompletionHandler<WriteResult>(){

            public void cancelled() {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Transfer of file {0} was cancelled.", file.getAbsolutePath());
                }
                OutputBuffer.this.serverResponse.resume();
            }

            public void failed(Throwable throwable) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, String.format("Failed to transfer file %s.  Cause: %s.", file.getAbsolutePath(), throwable.getMessage()), throwable);
                }
                OutputBuffer.this.serverResponse.resume();
            }

            public void completed(WriteResult result) {
                OutputBuffer.this.serverResponse.resume();
            }

            public void updated(WriteResult result) {
            }
        };
        return ch;
    }

    private CompletionHandler<WriteResult> suspendAndCreateHandler(final CompletionHandler<WriteResult> handler) {
        this.serverResponse.suspend();
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                handler.cancelled();
                OutputBuffer.this.serverResponse.resume();
            }

            public void failed(Throwable throwable) {
                handler.failed(throwable);
                OutputBuffer.this.serverResponse.resume();
            }

            public void completed(WriteResult result) {
                handler.completed((Object)result);
                OutputBuffer.this.serverResponse.resume();
            }

            public void updated(WriteResult result) {
                handler.updated((Object)result);
            }
        };
    }

    private final class ByteArrayCloner
    implements MessageCloner<Buffer> {
        private ByteArrayCloner() {
        }

        public Buffer clone(Connection connection, Buffer originalMessage) {
            if (OutputBuffer.this.temporaryWriteBuffer.isDisposed()) {
                return originalMessage;
            }
            if (originalMessage.isComposite()) {
                CompositeBuffer compositeBuffer = (CompositeBuffer)originalMessage;
                compositeBuffer.shrink();
                if (!OutputBuffer.this.temporaryWriteBuffer.isDisposed()) {
                    if (compositeBuffer.remaining() == OutputBuffer.this.temporaryWriteBuffer.remaining()) {
                        compositeBuffer.allowInternalBuffersDispose(false);
                        compositeBuffer.tryDispose();
                        return OutputBuffer.this.temporaryWriteBuffer.cloneContent();
                    }
                    compositeBuffer.replace((Buffer)OutputBuffer.this.temporaryWriteBuffer, OutputBuffer.this.temporaryWriteBuffer.cloneContent());
                }
                return originalMessage;
            }
            return OutputBuffer.this.temporaryWriteBuffer.cloneContent();
        }
    }

    public static interface LifeCycleListener {
        public void onCommit() throws IOException;
    }

    private class OnErrorCompletionHandler
    extends EmptyCompletionHandler<WriteResult> {
        private OnErrorCompletionHandler() {
        }

        public void failed(Throwable throwable) {
            OutputBuffer.this.asyncError.compareAndSet(null, throwable);
            WriteHandler localHandler = OutputBuffer.this.handler;
            OutputBuffer.this.handler = null;
            if (localHandler != null) {
                localHandler.onError(throwable);
            }
        }

        /* synthetic */ OnErrorCompletionHandler(OnErrorCompletionHandler onErrorCompletionHandler, OnErrorCompletionHandler onErrorCompletionHandler2) {
            this();
        }
    }

    private final class OnWritePossibleCompletionHandler
    extends OnErrorCompletionHandler {
        private OnWritePossibleCompletionHandler() {
            super(null, null);
        }

        public void completed(WriteResult result) {
            OutputBuffer.this.notifyWritePossible();
        }
    }
}

