/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.CompressionLevel;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class CompressionEncodingFilter
implements EncodingFilter {
    private final CompressionLevel compressionLevel;
    private final int compressionMinSize;
    private final String[] compressableMimeTypes;
    private final String[] noCompressionUserAgents;
    private final String[] aliases;

    public CompressionEncodingFilter(CompressionLevel compressionLevel, int compressionMinSize, String[] compressableMimeTypes, String[] noCompressionUserAgents, String[] aliases) {
        this.compressionLevel = compressionLevel;
        this.compressionMinSize = compressionMinSize;
        this.compressableMimeTypes = compressableMimeTypes;
        this.noCompressionUserAgents = noCompressionUserAgents;
        this.aliases = aliases;
    }

    public boolean applyEncoding(HttpHeader httpPacket) {
        DataChunk userAgentValueDC;
        switch (this.compressionLevel) {
            case OFF: {
                return false;
            }
        }
        if (Protocol.HTTP_1_1 != httpPacket.getProtocol()) {
            return false;
        }
        if (!httpPacket.getContentEncodings().isEmpty()) {
            return false;
        }
        HttpResponsePacket responsePacket = (HttpResponsePacket)httpPacket;
        MimeHeaders responseHeaders = responsePacket.getHeaders();
        DataChunk contentEncodingMB = responseHeaders.getValue(Header.ContentEncoding);
        if (contentEncodingMB != null && !contentEncodingMB.isNull()) {
            return false;
        }
        MimeHeaders requestHeaders = responsePacket.getRequest().getHeaders();
        if (!this.userAgentRequestsCompression(requestHeaders)) {
            return false;
        }
        if (this.compressionLevel == CompressionLevel.FORCE) {
            responsePacket.setChunked(true);
            responsePacket.setContentLength(-1);
            return true;
        }
        if (this.noCompressionUserAgents.length > 0 && (userAgentValueDC = requestHeaders.getValue(Header.UserAgent)) != null && CompressionEncodingFilter.indexOf(this.noCompressionUserAgents, userAgentValueDC) != -1) {
            return false;
        }
        long contentLength = responsePacket.getContentLength();
        if ((contentLength == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes.length > 0) {
            boolean found;
            boolean bl = found = CompressionEncodingFilter.indexOfStartsWith(this.compressableMimeTypes, responsePacket.getContentType()) != -1;
            if (found) {
                responsePacket.setChunked(true);
                responsePacket.setContentLength(-1);
            }
            return found;
        }
        responsePacket.setChunked(true);
        responsePacket.setContentLength(-1);
        return true;
    }

    private boolean userAgentRequestsCompression(MimeHeaders requestHeaders) {
        int qvalueEnd;
        DataChunk acceptEncodingDC = requestHeaders.getValue(Header.AcceptEncoding);
        if (acceptEncodingDC == null) {
            return false;
        }
        String alias = null;
        int i = 0;
        int len = this.aliases.length;
        while (i < len) {
            alias = this.aliases[i];
            int idx = acceptEncodingDC.indexOf(alias, 0);
            if (idx != -1) break;
            alias = null;
            ++i;
        }
        if (alias == null) {
            return false;
        }
        int qvalueStart = acceptEncodingDC.indexOf(';', alias.length());
        return qvalueStart == -1 || HttpUtils.convertQValueToFloat((DataChunk)acceptEncodingDC, (int)((qvalueStart = acceptEncodingDC.indexOf('=', qvalueStart)) + 1), (int)(qvalueEnd = acceptEncodingDC.indexOf(',', qvalueStart))) != 0.0f;
    }

    public boolean applyDecoding(HttpHeader httpPacket) {
        return false;
    }

    private static int indexOf(String[] aliases, DataChunk dc) {
        int i = 0;
        while (i < aliases.length) {
            String alias = aliases[i];
            if (dc.indexOf(alias, 0) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOfStartsWith(String[] aliases, String s) {
        int i = 0;
        while (i < aliases.length) {
            String alias = aliases[i];
            if (s.startsWith(alias)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

