//Licensed under Apache License version 2.0
//Original license LGPL

// %Z%%M%, %I%, %G%
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package samples;

import java.io.IOException;
import java.util.Enumeration;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;

/**
 * Sample Code for Service Discovery using JmDNS and a ServiceListener.
 * <p>
 * Run the main method of this class. It listens for HTTP services and lists all changes on System.out.
 *
 * @author Werner Randelshofer
 * @version %I%, %G%
 */
public class DiscoverServices
{

    static class SampleListener implements ServiceListener
    {
        public void serviceAdded(final ServiceEvent event)
        {
            System.out.println("Service added : " + event.getName() + "." + event.getType());

            event.getDNS().requestServiceInfo(event.getType(), event.getName());
        }

        public void serviceRemoved(final ServiceEvent event)
        {
            System.out.println("Service removed : " + event.getName() + "." + event.getType());
        }

        public void serviceResolved(final ServiceEvent event)
        {
            System.out.println("---------- ------ -----------");
            System.out.println("---------- ------ -----------");
            
            System.out.println("Service resolved: " + event.getInfo());
            System.out.println("Name="+event.getName());
            System.out.println("Type="+event.getType());
            final ServiceInfo info2 = event.getInfo();
            System.out.println("Address="+info2.getAddress());
            System.out.println("Host Address="+info2.getHostAddress());
            System.out.println("InetAddress="+info2.getInetAddress());
            System.out.println("Port="+info2.getPort());
            System.out.println("Name="+info2.getName());
            System.out.println("Server="+info2.getServer());
            System.out.println("Nice Text String="+info2.getNiceTextString());
            System.out.println("Service Info properties   : ");
            for (final Enumeration<String> enumeration = info2.getPropertyNames(); enumeration.hasMoreElements();) {
                final String propertyName = enumeration.nextElement();
                System.out.println("\t" + propertyName + "=" + info2.getPropertyString(propertyName));
            }
            System.out.println("---------- ------ -----------");
            System.out.println("---------- ------ -----------");
            System.out.println();
        }
    }

    /**
     * @param args
     *            the command line arguments
     */
    public static void main(final String[] args)
    {
        try
        {
            /*
             * Activate these lines to see log messages of JmDNS Logger logger =
             * Logger.getLogger(JmDNS.class.getName()); ConsoleHandler handler = new ConsoleHandler();
             * logger.addHandler(handler); logger.setLevel(Level.FINER); handler.setLevel(Level.FINER);
             */
            final JmDNS jmdns = JmDNS.create();
            jmdns.addServiceListener("_eleven._tcp.local.", new SampleListener());

            System.out.println("Press q and Enter, to quit");
            int b;
            while ((b = System.in.read()) != -1 && (char) b != 'q')
            {
                /* Stub */
            }
            jmdns.close();
            System.out.println("Done");
        }
        catch (final IOException e)
        {
            e.printStackTrace();
        }
    }
}
