/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
final class EmptyImmutableBiMap
extends ImmutableBiMap<Object, Object> {
    static final EmptyImmutableBiMap INSTANCE = new EmptyImmutableBiMap();

    private EmptyImmutableBiMap() {
    }

    @Override
    public ImmutableBiMap<Object, Object> inverse() {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public ImmutableSet<Object> values() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return false;
    }

    @Override
    public Object get(@Nullable Object key) {
        return null;
    }

    @Override
    public ImmutableSet<Map.Entry<Object, Object>> entrySet() {
        return ImmutableSet.of();
    }

    @Override
    ImmutableSet<Map.Entry<Object, Object>> createEntrySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableSet<Object> keySet() {
        return ImmutableSet.of();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.isEmpty();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    Object readResolve() {
        return INSTANCE;
    }
}

