/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoBufferWrapperImpl;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.MultiplexIsoBufferWrapperImpl;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.h264.AccessUnit;
import com.googlecode.mp4parser.h264.AccessUnitSourceImpl;
import com.googlecode.mp4parser.h264.AnnexBNALUnitReader;
import com.googlecode.mp4parser.h264.StreamParams;
import com.googlecode.mp4parser.h264.model.NALUnit;
import com.googlecode.mp4parser.h264.model.NALUnitType;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SEI;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import com.googlecode.mp4parser.h264.model.SliceHeader;
import com.googlecode.mp4parser.h264.model.SliceType;
import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.h264.read.SliceHeaderReader;
import com.googlecode.mp4parser.util.Path;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawH264Track
extends AbstractTrack
implements StreamParams {
    private static int a;
    List<IsoBufferWrapper> samples = new ArrayList<IsoBufferWrapper>();
    StreamParams streamParams;
    double fps = 30.0;

    public static void main(String[] args) throws IOException {
        IsoFile isoFile = new IsoFile(new IsoBufferWrapperImpl(new File("/home/sannies/vw.mp4")));
        Path p = new Path(isoFile);
        isoFile.parse();
        CompositionTimeToSample ctts = (CompositionTimeToSample)p.getPath("/moov/trak[1]/mdia/minf/stbl/ctts");
        int[] cts = CompositionTimeToSample.blowupCompositionTimes(ctts.getEntries());
        RawH264Track track = new RawH264Track(new IsoBufferWrapperImpl(new File("/home/sannies/vw_track2.h264")));
    }

    public RawH264Track(IsoBufferWrapperImpl rawH264) throws IOException {
        AccessUnit au;
        InnerAccessUnit current = new InnerAccessUnit();
        InnerAccessUnit previous = new InnerAccessUnit();
        AnnexBNALUnitReader nalUnitReader = new AnnexBNALUnitReader(rawH264);
        AccessUnitSourceImpl accessUnitSource = new AccessUnitSourceImpl(nalUnitReader);
        this.streamParams = accessUnitSource;
        SliceHeaderReader sliceHeaderReader = new SliceHeaderReader(accessUnitSource);
        long frameNumInGop = 0L;
        while ((au = accessUnitSource.nextAccessUnit()) != null) {
            IsoBufferWrapper nalUnitBuffer;
            LinkedList<IsoBufferWrapper> nals = new LinkedList<IsoBufferWrapper>();
            while ((nalUnitBuffer = au.nextNALUnit()) != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new IsoOutputStream(baos).writeUInt32(nalUnitBuffer.size());
                nals.add(new IsoBufferWrapperImpl(baos.toByteArray()));
                nals.add(nalUnitBuffer);
                NALUnit nalUnit = NALUnit.read(nalUnitBuffer);
                if (nalUnit.type == NALUnitType.IDR_SLICE || nalUnit.type == NALUnitType.NON_IDR_SLICE || nalUnit.type == NALUnitType.AUX_SLICE || nalUnit.type == NALUnitType.SLICE_PART_A || nalUnit.type == NALUnitType.SLICE_PART_B || nalUnit.type == NALUnitType.SLICE_PART_C) {
                    current.sliceHeaders.add(sliceHeaderReader.read(nalUnit, new CAVLCReader(nalUnitBuffer)));
                }
                if (++a % 1000 != 0) continue;
                System.err.println(a);
            }
            this.samples.add(new MultiplexIsoBufferWrapperImpl(nals));
            RawH264Track.decodedPoc(current, previous);
            if (current.poc == 0) {
                frameNumInGop = 0L;
            }
            System.err.println("cts: " + ((long)current.poc - frameNumInGop * 2L));
            previous = current;
            ++frameNumInGop;
            current = new InnerAccessUnit();
        }
    }

    @Override
    public List<IsoBufferWrapper> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox sampleDescriptionBox = new SampleDescriptionBox();
        return null;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return new long[0];
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return null;
    }

    @Override
    public Track.Type getType() {
        return null;
    }

    @Override
    public SeqParameterSet getSPS(int id) {
        return this.streamParams.getSPS(id);
    }

    @Override
    public PictureParameterSet getPPS(int id) {
        return this.streamParams.getPPS(id);
    }

    static InnerAccessUnit decodePocType0(InnerAccessUnit current, InnerAccessUnit prev) {
        int prevPicOrderCntLsb;
        int prevPicOrderCntMsb;
        int TopFieldOrderCnt = Integer.MAX_VALUE;
        int BottomFieldOrderCnt = Integer.MAX_VALUE;
        if (current.sliceHeaders.get((int)0).slice_type == SliceType.I || current.sliceHeaders.get((int)0).slice_type == SliceType.SI) {
            prevPicOrderCntMsb = 0;
            prevPicOrderCntLsb = 0;
        } else {
            if (current.sei != null) {
                for (SEI.SEIMessage message : current.sei.messages) {
                    if (message.payloadType != 1) continue;
                    throw new RuntimeException("That needs to be implemented. 7687526897568234.");
                }
            }
            prevPicOrderCntMsb = prev.picOrderCntMsb;
            prevPicOrderCntLsb = prev.sliceHeaders.get((int)0).pic_order_cnt_lsb;
        }
        int MaxPicOrderCntLsb = 1 << current.sliceHeaders.get((int)0).sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
        int picOrderCntMsb = current.sliceHeaders.get((int)0).pic_order_cnt_lsb < prevPicOrderCntLsb && prevPicOrderCntLsb - current.sliceHeaders.get((int)0).pic_order_cnt_lsb >= MaxPicOrderCntLsb / 2 ? prevPicOrderCntMsb + MaxPicOrderCntLsb : (current.sliceHeaders.get((int)0).pic_order_cnt_lsb > prevPicOrderCntLsb && current.sliceHeaders.get((int)0).pic_order_cnt_lsb - prevPicOrderCntLsb > MaxPicOrderCntLsb / 2 ? prevPicOrderCntMsb - MaxPicOrderCntLsb : prevPicOrderCntMsb);
        if (!current.sliceHeaders.get((int)0).bottom_field_flag) {
            TopFieldOrderCnt = picOrderCntMsb + current.sliceHeaders.get((int)0).pic_order_cnt_lsb;
        }
        if (current.sliceHeaders.get((int)0).bottom_field_flag) {
            BottomFieldOrderCnt = !current.sliceHeaders.get((int)0).field_pic_flag ? TopFieldOrderCnt + current.sliceHeaders.get((int)0).delta_pic_order_cnt_bottom : picOrderCntMsb + current.sliceHeaders.get((int)0).pic_order_cnt_lsb;
        }
        current.poc = current.sliceHeaders.get((int)0).sps.frame_mbs_only_flag || !current.sliceHeaders.get((int)0).field_pic_flag ? Math.min(TopFieldOrderCnt, BottomFieldOrderCnt) : (current.sliceHeaders.get((int)0).bottom_field_flag ? BottomFieldOrderCnt : TopFieldOrderCnt);
        return current;
    }

    static InnerAccessUnit decodePocType1(InnerAccessUnit current, InnerAccessUnit prev) {
        System.err.println("decodePocType1");
        throw new UnsupportedOperationException("Please implement decodePocType1");
    }

    static InnerAccessUnit decodePocType2(InnerAccessUnit current, InnerAccessUnit prev) {
        System.err.println("decodePocType2");
        throw new UnsupportedOperationException("Please implement decodePocType2");
    }

    static InnerAccessUnit insertDecodingTime(InnerAccessUnit current, InnerAccessUnit previous) {
        if (current.sliceHeaders.get((int)0).sps.vuiParams.pic_struct_present_flag) {
            throw new UnsupportedOperationException("Hmm I cannot deal with picTimingSei");
        }
        int DeltaTfiDivisorIdx = 1 + (1 - (!current.sliceHeaders.get((int)0).field_pic_flag ? 0 : 1));
        current.decodingTime = previous.decodingTime + 2 * current.sliceHeaders.get((int)0).sps.vuiParams.num_units_in_tick * DeltaTfiDivisorIdx;
        return current;
    }

    static InnerAccessUnit decodedPoc(InnerAccessUnit current, InnerAccessUnit previous) {
        RawH264Track.insertDecodingTime(current, previous);
        switch (current.sliceHeaders.get((int)0).sps.pic_order_cnt_type) {
            case 0: {
                return RawH264Track.decodePocType0(current, previous);
            }
            case 1: {
                return RawH264Track.decodePocType1(current, previous);
            }
            case 2: {
                return RawH264Track.decodePocType2(current, previous);
            }
        }
        return null;
    }

    public void setFps(double fps) {
        this.fps = fps;
    }

    static class InnerAccessUnit {
        int decodingTime;
        int picOrderCntMsb;
        int poc;
        SEI sei;
        List<SliceHeader> sliceHeaders = new LinkedList<SliceHeader>();

        InnerAccessUnit() {
        }
    }
}

