/*
 * Decompiled with CFR 0.152.
 */
package com.javacodegeeks.stringsearch;

import java.util.ArrayList;
import java.util.List;

public class SMN {
    private char[] x;
    private int ell;
    private int m;
    private Cell[] list;

    private static int getTransition(char[] x, int p, Cell[] lst, char c) {
        int m = x.length;
        if (p < m - 1 && x[p + 1] == c) {
            return p + 1;
        }
        if (p > -1) {
            Cell cell = lst[p];
            while (cell != null) {
                if (x[cell.element] == c) {
                    return cell.element;
                }
                cell = cell.next;
            }
            return -1;
        }
        return -1;
    }

    private static void setTransition(int p, int q, Cell[] list) {
        Cell cell = new Cell();
        cell.element = q;
        cell.next = list[p];
        list[p] = cell;
    }

    private static int preSimon(char[] x, Cell[] list) {
        int i;
        int m = x.length;
        for (i = 0; i < m - 2; ++i) {
            list[i] = null;
        }
        int ell = -1;
        for (i = 1; i < m; ++i) {
            int k = ell;
            Cell cell = ell == -1 ? null : list[k];
            ell = -1;
            if (x[i] == x[k + 1]) {
                ell = k + 1;
            } else {
                SMN.setTransition(i - 1, k + 1, list);
            }
            while (cell != null) {
                k = cell.element;
                if (x[i] == x[k]) {
                    ell = k;
                } else {
                    SMN.setTransition(i - 1, k, list);
                }
                cell = cell.next;
            }
        }
        return ell;
    }

    public static List<Integer> findAll(String pattern, String source) {
        char[] x = pattern.toCharArray();
        char[] y = source.toCharArray();
        int m = x.length;
        int n = y.length;
        Cell[] list = new Cell[m];
        ArrayList<Integer> result = new ArrayList<Integer>();
        int ell = SMN.preSimon(x, list);
        int state = -1;
        for (int j = 0; j < n; ++j) {
            if ((state = SMN.getTransition(x, state, list, y[j])) < m - 1) continue;
            result.add(j - m + 1);
            state = ell;
        }
        return result;
    }

    public static SMN compile(String pattern) {
        char[] x = pattern.toCharArray();
        int m = x.length;
        Cell[] list = new Cell[m];
        int ell = SMN.preSimon(x, list);
        SMN smn = new SMN();
        smn.ell = ell;
        smn.list = list;
        smn.m = m;
        smn.x = x;
        return smn;
    }

    public List<Integer> findAll(String source) {
        char[] y = source.toCharArray();
        int n = y.length;
        ArrayList<Integer> result = new ArrayList<Integer>();
        int state = -1;
        for (int j = 0; j < n; ++j) {
            if ((state = SMN.getTransition(this.x, state, this.list, y[j])) < this.m - 1) continue;
            result.add(j - this.m + 1);
            state = this.ell;
        }
        return result;
    }

    private static class Cell {
        int element;
        Cell next;

        private Cell() {
        }
    }
}

