/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String VERSION_FILE = "VERSION.txt";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");
    private final Version _version;

    protected VersionUtil() {
        Version v = null;
        try {
            v = VersionUtil.versionFor(this.getClass());
        }
        catch (Exception e) {
            System.err.println("ERROR: Failed to load Version information for bundle (via " + this.getClass().getName() + ").");
        }
        if (v == null) {
            v = Version.unknownVersion();
        }
        this._version = v;
    }

    public Version version() {
        return this._version;
    }

    public static Version versionFor(Class<?> cls) {
        InputStream in = cls.getResourceAsStream(VERSION_FILE);
        if (in == null) {
            return Version.unknownVersion();
        }
        try {
            Version version;
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            try {
                version = VersionUtil.doReadVersion(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException e) {
                    Version version2 = Version.unknownVersion();
                    return version2;
                }
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return version;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Version doReadVersion(Reader reader) {
        String artifact;
        String group;
        String version;
        block14: {
            version = null;
            group = null;
            artifact = null;
            BufferedReader br = new BufferedReader(reader);
            try {
                try {
                    version = br.readLine();
                    if (version != null && (group = br.readLine()) != null) {
                        artifact = br.readLine();
                    }
                }
                catch (IOException iOException) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (group != null) {
            group = group.trim();
        }
        if (artifact != null) {
            artifact = artifact.trim();
        }
        return VersionUtil.parseVersion(version, group, artifact);
    }

    public static Version mavenVersionFor(ClassLoader classLoader, String groupId, String artifactId) {
        InputStream pomPoperties = classLoader.getResourceAsStream("META-INF/maven/" + groupId.replaceAll("\\.", "/") + "/" + artifactId + "/pom.properties");
        if (pomPoperties != null) {
            try {
                Properties props = new Properties();
                props.load(pomPoperties);
                String versionStr = props.getProperty("version");
                String pomPropertiesArtifactId = props.getProperty("artifactId");
                String pomPropertiesGroupId = props.getProperty("groupId");
                Version version = VersionUtil.parseVersion(versionStr, pomPropertiesGroupId, pomPropertiesArtifactId);
                return version;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    pomPoperties.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Version.unknownVersion();
    }

    @Deprecated
    public static Version parseVersion(String versionStr) {
        return VersionUtil.parseVersion(versionStr, null, null);
    }

    public static Version parseVersion(String versionStr, String groupId, String artifactId) {
        if (versionStr == null) {
            return null;
        }
        if ((versionStr = versionStr.trim()).length() == 0) {
            return null;
        }
        String[] parts = VERSION_SEPARATOR.split(versionStr);
        int major = VersionUtil.parseVersionPart(parts[0]);
        int minor = parts.length > 1 ? VersionUtil.parseVersionPart(parts[1]) : 0;
        int patch = parts.length > 2 ? VersionUtil.parseVersionPart(parts[2]) : 0;
        String snapshot = parts.length > 3 ? parts[3] : null;
        return new Version(major, minor, patch, snapshot, groupId, artifactId);
    }

    protected static int parseVersionPart(String partStr) {
        partStr = partStr.toString();
        int len = partStr.length();
        int number = 0;
        int i = 0;
        while (i < len) {
            char c = partStr.charAt(i);
            if (c > '9' || c < '0') break;
            number = number * 10 + (c - 48);
            ++i;
        }
        return number;
    }
}

