/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.examples.ExampleUtils;
import org.javasimon.utils.BenchmarkUtils;
import org.javasimon.utils.GoogleChartImageGenerator;
import org.javasimon.utils.SimonUtils;

public final class ManagerVsStopwatchComparison {
    private static final int LOOP = 10000000;
    private static final String NAME = SimonUtils.generateNameForClass((String)"-stopwatch");

    private ManagerVsStopwatchComparison() {
    }

    public static void main(String[] args) {
        ExampleUtils.fillManagerWithSimons(100000);
        StopwatchSample[] results = BenchmarkUtils.run((int)2, (int)5, (BenchmarkUtils.Task[])new BenchmarkUtils.Task[]{new BenchmarkUtils.Task("getStopwatch"){

            public void perform() throws Exception {
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)NAME);
                }
            }
        }, new BenchmarkUtils.Task("start-stop"){

            public void perform() throws Exception {
                Stopwatch stopwatch = SimonManager.getStopwatch((String)NAME).reset();
                for (int i = 0; i < 10000000; ++i) {
                    stopwatch.start().stop();
                }
            }
        }, new BenchmarkUtils.Task("get-start-stop"){

            public void perform() throws Exception {
                SimonManager.getStopwatch((String)NAME).reset();
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)NAME).start().stop();
                }
            }
        }, new BenchmarkUtils.Task("clear-get-start-stop"){

            public void perform() throws Exception {
                SimonManager.clear();
                SimonManager.getStopwatch((String)NAME).reset();
                for (int i = 0; i < 10000000; ++i) {
                    SimonManager.getStopwatch((String)NAME).start().stop();
                }
            }
        }});
        System.out.println("\nGoogle Chart avg:\n" + GoogleChartImageGenerator.barChart((StopwatchSample[])results, (String)"10M-loop duration", (double)1000000.0, (String)"ms", (boolean)false));
    }
}

