/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.ISemaphore;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;

@JMXDescription(value="A distributed Semaphore")
public class SemaphoreMBean
extends AbstractMBean<ISemaphore> {
    public SemaphoreMBean(ISemaphore managedObject, ManagementService managementService) {
        super(managedObject, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Semaphore", this.getName());
    }

    @JMXAttribute(value="CurrentPermits")
    @JMXDescription(value="availablePermits() result")
    public long getCurrentPermits() {
        return this.available();
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Instance name of the Semaphore")
    public String getName() {
        return ((ISemaphore)this.getManagedObject()).getName();
    }

    @JMXOperation(value="available")
    @JMXDescription(value="number of permits immediately available")
    public int available() {
        return ((ISemaphore)this.getManagedObject()).availablePermits();
    }

    @JMXOperation(value="drain")
    @JMXDescription(value="acquire and return all permits immediately available")
    public int drain() {
        return ((ISemaphore)this.getManagedObject()).drainPermits();
    }

    @JMXOperation(value="reduce")
    @JMXDescription(value="reduce the number of permits available")
    public void reduce(int reduction) {
        ((ISemaphore)this.getManagedObject()).reducePermits(reduction);
    }

    @JMXOperation(value="release")
    @JMXDescription(value="increase the number of permits available")
    public void release(int permits) {
        ((ISemaphore)this.getManagedObject()).release(permits);
    }
}

