/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalCountDownLatchOperationStatsImpl;
import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalCountDownLatchOperationStats;
import java.util.concurrent.atomic.AtomicLong;

public class CountDownLatchOperationsCounter
extends OperationsCounterSupport<LocalCountDownLatchOperationStats> {
    private static final LocalCountDownLatchOperationStats empty = new LocalCountDownLatchOperationStatsImpl();
    private AtomicLong awaitsReleased = new AtomicLong();
    private AtomicLong gatesOpened = new AtomicLong();
    private OperationsCounterSupport.OperationCounter await = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter countdown = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter other = new OperationsCounterSupport.OperationCounter(this);

    public CountDownLatchOperationsCounter() {
    }

    public CountDownLatchOperationsCounter(long interval) {
        super(interval);
    }

    public void incrementAwait(long elapsed) {
        this.await.count(elapsed);
        this.publishSubResult();
    }

    public void incrementCountDown(long elapsed, int releasedThreads) {
        this.countdown.count(elapsed);
        if (releasedThreads > 0) {
            this.awaitsReleased.addAndGet(releasedThreads);
            this.gatesOpened.incrementAndGet();
        }
        this.publishSubResult();
    }

    public void incrementOther(long elapsed) {
        this.other.count(elapsed);
        this.publishSubResult();
    }

    @Override
    LocalCountDownLatchOperationStatsImpl aggregateSubCounterStats() {
        LocalCountDownLatchOperationStatsImpl stats = new LocalCountDownLatchOperationStatsImpl();
        stats.periodStart = ((CountDownLatchOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        for (Object obj : this.listOfSubCounters) {
            CountDownLatchOperationsCounter sub = (CountDownLatchOperationsCounter)obj;
            stats.await.add(sub.await.count.get(), sub.await.totalLatency.get());
            stats.countdown.add(sub.countdown.count.get(), sub.countdown.totalLatency.get());
            stats.other.add(sub.other.count.get(), sub.other.totalLatency.get());
            stats.numberOfAwaitsReleased += sub.awaitsReleased.get();
            stats.numberOfGatesOpened += sub.gatesOpened.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    CountDownLatchOperationsCounter getAndReset() {
        CountDownLatchOperationsCounter newOne = new CountDownLatchOperationsCounter();
        newOne.await.set(this.await.copyAndReset());
        newOne.countdown.set(this.countdown.copyAndReset());
        newOne.other.set(this.other.copyAndReset());
        newOne.awaitsReleased.set(this.awaitsReleased.getAndSet(0L));
        newOne.gatesOpened.set(this.gatesOpened.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    @Override
    LocalCountDownLatchOperationStats getThis() {
        LocalCountDownLatchOperationStatsImpl stats = new LocalCountDownLatchOperationStatsImpl();
        stats.periodStart = this.startTime;
        LocalCountDownLatchOperationStatsImpl localCountDownLatchOperationStatsImpl = stats;
        localCountDownLatchOperationStatsImpl.getClass();
        stats.await = new LocalOperationStatsSupport.OperationStat(localCountDownLatchOperationStatsImpl, this.await.count.get(), this.await.totalLatency.get());
        LocalCountDownLatchOperationStatsImpl localCountDownLatchOperationStatsImpl2 = stats;
        localCountDownLatchOperationStatsImpl2.getClass();
        stats.countdown = new LocalOperationStatsSupport.OperationStat(localCountDownLatchOperationStatsImpl2, this.countdown.count.get(), this.countdown.totalLatency.get());
        LocalCountDownLatchOperationStatsImpl localCountDownLatchOperationStatsImpl3 = stats;
        localCountDownLatchOperationStatsImpl3.getClass();
        stats.other = new LocalOperationStatsSupport.OperationStat(localCountDownLatchOperationStatsImpl3, this.other.count.get(), this.other.totalLatency.get());
        stats.numberOfAwaitsReleased = this.awaitsReleased.get();
        stats.numberOfGatesOpened = this.gatesOpened.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalCountDownLatchOperationStats getEmpty() {
        return empty;
    }
}

