/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.impl.ThreadContext;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ClassLoader classLoader;

    public ExecutorThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, ClassLoader classLoader) {
        this.group = threadGroup;
        this.classLoader = classLoader;
        this.namePrefix = threadNamePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L){

            @Override
            public void run() {
                try {
                    try {
                        super.run();
                    }
                    catch (OutOfMemoryError e) {
                        OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                        try {
                            ThreadContext.shutdown(this);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        ThreadContext.shutdown(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.setContextClassLoader(this.classLoader);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

