/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.OutputStream;

public class OutputChunked
extends Output {
    public OutputChunked() {
        super(2048);
    }

    public OutputChunked(int n) {
        super(n);
    }

    public OutputChunked(OutputStream outputStream) {
        super(outputStream, 2048);
    }

    public OutputChunked(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    public void flush() throws KryoException {
        if (this.position() > 0) {
            try {
                this.writeChunkSize();
            }
            catch (IOException iOException) {
                throw new KryoException(iOException);
            }
        }
        super.flush();
    }

    private void writeChunkSize() throws IOException {
        int n = this.position();
        OutputStream outputStream = this.getOutputStream();
        if ((n & 0xFFFFFF80) == 0) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0x7F | 0x80);
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0x7F | 0x80);
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0x7F | 0x80);
        if (((n >>>= 7) & 0xFFFFFF80) == 0) {
            outputStream.write(n);
            return;
        }
        outputStream.write(n & 0x7F | 0x80);
        outputStream.write(n >>>= 7);
    }

    public void endChunks() {
        this.flush();
        try {
            this.getOutputStream().write(0);
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }
}

