/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.Stopwatch;
import org.javasimon.StopwatchImpl;
import org.javasimon.utils.SimonUtils;

public final class Split {
    private volatile Stopwatch stopwatch;
    private volatile long start;
    private volatile long total;
    private volatile boolean enabled;
    private volatile boolean running;

    public Split() {
        this.enabled = true;
        this.running = true;
        this.start = System.nanoTime();
    }

    Split(Stopwatch stopwatch, long start) {
        assert (start > 0L) : "start ns value should not be 0 in this constructor!";
        this.stopwatch = stopwatch;
        this.start = start;
        this.enabled = true;
        this.running = true;
    }

    Split(Stopwatch stopwatch) {
        assert (!stopwatch.isEnabled()) : "stopwatch must be disabled in this constructor!";
        this.stopwatch = stopwatch;
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public Split stop() {
        if (!this.running) {
            return this;
        }
        this.running = false;
        long nowNanos = System.nanoTime();
        this.total = nowNanos - this.start;
        if (this.stopwatch != null) {
            ((StopwatchImpl)this.stopwatch).stop(this, this.start, nowNanos);
        }
        return this;
    }

    public long runningFor() {
        if (!this.running) {
            return this.total;
        }
        if (this.enabled) {
            return System.nanoTime() - this.start;
        }
        return 0L;
    }

    public String presentRunningFor() {
        return SimonUtils.presentNanoTime(this.runningFor());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getStart() {
        return this.start;
    }

    public String toString() {
        if (!this.enabled) {
            return "Split created from disabled Stopwatch";
        }
        if (this.running) {
            return "Running split" + (this.stopwatch != null ? " for Stopwatch '" + this.stopwatch.getName() + "': " : ": ") + SimonUtils.presentNanoTime(this.runningFor());
        }
        return "Stopped split" + (this.stopwatch != null ? " for Stopwatch '" + this.stopwatch.getName() + "': " : ": ") + SimonUtils.presentNanoTime(this.total);
    }
}

