/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.javasimon.Manager;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.SimonState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSimon
implements Simon {
    protected Manager manager;
    protected volatile boolean enabled;
    protected long firstUsage;
    protected long lastUsage;
    private final String name;
    private SimonState state = SimonState.INHERIT;
    private Simon parent;
    private final List<Simon> children = new CopyOnWriteArrayList<Simon>();
    private String note;
    private long resetTimestamp;
    private Map<String, Object> attributes;

    AbstractSimon(String name, Manager manager) {
        this.name = name;
        this.manager = manager;
        if (name == null || name.equals("")) {
            this.state = SimonState.ENABLED;
            this.enabled = true;
        }
    }

    @Override
    public final Simon getParent() {
        return this.parent;
    }

    @Override
    public final List<Simon> getChildren() {
        return this.children;
    }

    final void setParent(Simon parent) {
        this.parent = parent;
    }

    final synchronized void addChild(AbstractSimon simon) {
        this.children.add(simon);
        simon.setParent(this);
        simon.enabled = this.enabled;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final synchronized void setState(SimonState state, boolean overrule) {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isAnonymousOrRootSimon() || !state.equals((Object)SimonState.INHERIT)) {
            this.state = state;
            this.updateAndPropagateEffectiveState(this.shouldBeEffectivlyEnabled(), overrule);
        }
    }

    private boolean isAnonymousOrRootSimon() {
        return this.name == null || this.name.equals("");
    }

    private synchronized boolean shouldBeEffectivlyEnabled() {
        if (this.state.equals((Object)SimonState.INHERIT)) {
            return this.parent.isEnabled();
        }
        return this.state.equals((Object)SimonState.ENABLED);
    }

    private synchronized void updateAndPropagateEffectiveState(boolean enabled, boolean overrule) {
        this.enabled = enabled;
        for (Simon child : this.children) {
            if (overrule) {
                ((AbstractSimon)child).state = SimonState.INHERIT;
            }
            if (!child.getState().equals((Object)SimonState.INHERIT)) continue;
            ((AbstractSimon)child).updateAndPropagateEffectiveState(enabled, overrule);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void resetCommon() {
        this.resetTimestamp = System.currentTimeMillis();
        this.manager.callback().onSimonReset(this);
    }

    @Override
    public synchronized long getLastReset() {
        return this.resetTimestamp;
    }

    @Override
    public final synchronized SimonState getState() {
        return this.state;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public long getFirstUsage() {
        return this.firstUsage;
    }

    @Override
    public long getLastUsage() {
        return this.lastUsage;
    }

    void replaceChild(Simon simon, AbstractSimon newSimon) {
        this.children.remove(simon);
        if (newSimon != null) {
            this.children.add(newSimon);
            newSimon.setParent(this);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptySet().iterator();
        }
        return this.attributes.keySet().iterator();
    }

    void sampleCommon(Sample sample) {
        sample.setName(this.name);
        sample.setNote(this.note);
        sample.setFirstUsage(this.firstUsage);
        sample.setLastUsage(this.lastUsage);
        sample.setLastReset(this.resetTimestamp);
    }

    public synchronized String toString() {
        return " [" + this.name + " " + (Object)((Object)this.state) + (this.getNote() != null && this.getNote().length() != 0 ? " \"" + this.getNote() + "\"]" : "]");
    }
}

